% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenotypeBreaks.R
\name{genotype.binom}
\alias{genotype.binom}
\title{Assign states to any given region using binomial test.}
\usage{
genotype.binom(wReads, cReads, background = 0.05, minReads = 10, log = FALSE)
}
\arguments{
\item{wReads}{Number of Watson reads.}

\item{cReads}{Number of Crick reads.}

\item{background}{The percent (e.g. 0.05 = 5\%) of background reads allowed for WW or CC genotype calls.}

\item{minReads}{The minimal number of reads between two breaks required for genotyping.}

\item{log}{Set to \code{TRUE} if you want to calculate probability in log space.}
}
\value{
A \code{list} with the $bestFit and $pval.
}
\description{
Assign states to any given region using binomial test.
}
\examples{
## Get Crick and Watson read counts
## Crick read count
cReads <- 30
## Watson read count
wReads <- 5  
genotype.binom(cReads = cReads, wReads = wReads, background = 0.05, minReads = 10, log = TRUE)

}
\author{
David Porubsky
}
