% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/breakpointr.R
\name{breakpointr}
\alias{breakpointr}
\title{Main function for the \pkg{\link{breakpointR}} package}
\usage{
breakpointr(
  inputfolder,
  outputfolder,
  configfile = NULL,
  numCPU = 1,
  reuse.existing.files = FALSE,
  windowsize = 1e+06,
  binMethod = "size",
  multi.sizes = NULL,
  pairedEndReads = FALSE,
  pair2frgm = FALSE,
  chromosomes = NULL,
  min.mapq = 10,
  filtAlt = FALSE,
  genoT = "fisher",
  trim = 10,
  peakTh = 0.33,
  zlim = 3.291,
  background = 0.05,
  minReads = 10,
  maskRegions = NULL,
  callHotSpots = FALSE,
  conf = 0.99
)
}
\arguments{
\item{inputfolder}{Folder with BAM files.}

\item{outputfolder}{Folder to output the results. If it does not exist it will be created.}

\item{configfile}{A file specifying the parameters of this function (without \code{inputfolder}, \code{outputfolder} and \code{configfile}). Having the parameters in a file can be handy if many samples with the same parameter settings are to be run. If a \code{configfile} is specified, it will take priority over the command line parameters.}

\item{numCPU}{The numbers of CPUs that are used. Should not be more than available on your machine.}

\item{reuse.existing.files}{A logical indicating whether or not existing files in \code{outputfolder} should be reused.}

\item{windowsize}{The window size used to calculate deltaWs, either number of reads or genomic size depending on \code{binMethod}.}

\item{binMethod}{Method used to calculate optimal number of reads in the window ("size", "reads"). By default \code{binMethod='size'}.}

\item{multi.sizes}{User defined multiplications of the original window size.}

\item{pairedEndReads}{Set to \code{TRUE} if you have paired-end reads in your file.}

\item{pair2frgm}{Set to \code{TRUE} if every paired-end read should be merged into a single fragment.}

\item{chromosomes}{If only a subset of the chromosomes should be binned, specify them here.}

\item{min.mapq}{Minimum mapping quality when importing from BAM files.}

\item{filtAlt}{Set to \code{TRUE} if you want to filter out alternative alignments defined in 'XA' tag.}

\item{genoT}{A method ('fisher' or 'binom') to genotype regions defined by a set of breakpoints.}

\item{trim}{The amount of outliers in deltaWs removed to calculate the stdev (10 will remove top 10\% and bottom 10\% of deltaWs).}

\item{peakTh}{The treshold that the peak deltaWs must pass to be considered a breakpoint (e.g. 0.33 is 1/3 of max(deltaW)).}

\item{zlim}{The number of stdev that the deltaW must pass the peakTh (ensures only significantly higher peaks are considered).}

\item{background}{The percent (e.g. 0.05 = 5\%) of background reads allowed for WW or CC genotype calls.}

\item{minReads}{The minimal number of reads between two breaks required for genotyping.}

\item{maskRegions}{List of regions to be excluded from the analysis (tab-separated file: chromosomes start end).}

\item{callHotSpots}{Search for regions of high abundance of breakpoints in single cells.}

\item{conf}{Desired confidence interval of localized breakpoints.}
}
\value{
\code{NULL}
}
\description{
This function is an easy-to-use wrapper to find breakpoints with \code{\link[breakpointR]{runBreakpointr}} in parallel, write the results to file, plot results and find hotspots.
}
\examples{
\dontrun{
## The following call produces plots and genome browser files for all BAM files in "my-data-folder"
breakpointr(inputfolder="my-data-folder", outputfolder="my-output-folder")}

}
\author{
David Porubsky, Aaron Taudt, Ashley Sanders
}
