% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeBranchpointWindowForExons.R
\name{makeBranchpointWindowForExons}
\alias{makeBranchpointWindowForExons}
\title{Make branchpoint window regions}
\usage{
makeBranchpointWindowForExons(id, idType, exons, forceClosestExon = FALSE)
}
\arguments{
\item{id}{identifier(s) for the query gene/transcript/exon id}

\item{idType}{type of id to match in the exon annotation file (\code{"gene_id"},
\code{"transcript_id"}, or \code{"exon_id"})}

\item{exons}{GRanges containing exon co-ordinates.}

\item{forceClosestExon}{Force branchpointer to find the closest exon and not the
exon annotated as 5' to the query}
}
\value{
Granges with formatted query
}
\description{
Generate branchpoint window regions corresponding to annotated exon(s) within a
queried gene, transcript or exon id
}
\examples{
smallExons <- system.file("extdata","gencode.v26.annotation.small.gtf",package = "branchpointer")
exons <- gtfToExons(smallExons)
windowquery <- makeBranchpointWindowForExons("ENSG00000139618.14", "gene_id", exons)
windowquery <- makeBranchpointWindowForExons("ENST00000357654.7", "transcript_id", exons)
windowquery <- makeBranchpointWindowForExons("ENSE00003518965.1", "exon_id", exons)
}
\author{
Beth Signal
}
