% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bnem_main.r
\name{validateGraph}
\alias{validateGraph}
\title{validate graph}
\usage{
validateGraph(
  CNOlist,
  fc = NULL,
  expression = NULL,
  model,
  bString,
  Egenes = 25,
  Sgene = 1,
  parameters = list(cutOffs = c(0, 1, 0), scoring = c(0.1, 0.2, 0.9)),
  plot = TRUE,
  disc = 0,
  affyIds = TRUE,
  relFit = FALSE,
  xrot = 25,
  Rowv = FALSE,
  Colv = FALSE,
  dendrogram = "none",
  soft = TRUE,
  colSideColors = NULL,
  affychip = "hgu133plus2",
  method = "s",
  ranks = FALSE,
  breaks = NULL,
  col = "RdYlGn",
  sizeFac = 10^-10,
  order = "rank",
  verbose = TRUE,
  ...
)
}
\arguments{
\item{CNOlist}{CNOlist object (see package CellNOptR), if available.}

\item{fc}{m x l matrix of foldchanges of gene expression values or 
equivalent input
(normalized pvalues, logodds, ...) for m E-genes and l contrasts. If left 
NULL, the gene expression
data is used to calculate naive foldchanges.}

\item{expression}{Optional normalized m x l matrix of gene expression data 
for m E-genes and l experiments.}

\item{model}{Model object including the search space, if available.
See CellNOptR::preprocessing.}

\item{bString}{Binary string denoting the hyper-graph.}

\item{Egenes}{Maximal number of visualized E-genes.}

\item{Sgene}{Integer denoting the S-gene. See
colnames(getSignals(CNOlist)[[1]]) to match integer with S-gene name.}

\item{parameters}{parameters for discrete case (not recommended);
has to be a list with entries cutOffs and scoring:
cutOffs = c(a,b,c) with a (cutoff for real zeros),
b (cutoff for real effects),
c = -1 for normal scoring, c between 0 and
1 for keeping only relevant % of E-genes,
between -1 and 0 for keeping only a specific quantile of E-genes,
and c > 1 for keeping the top c E-genes;
scoring = c(a,b,c) with a (weight for real effects),
c (weight for real zeros),
b (multiplicator for effects/zeros between a and c);}

\item{plot}{Plot the heatmap. If FALSE, only corresponding
information is printed.}

\item{disc}{Discretize the data.}

\item{affyIds}{Experimental. Turn Affymetrix Ids into HGNC
gene symbols.}

\item{relFit}{if TRUE a relative fit for each
E-gene is computed (not recommended)}

\item{xrot}{See function epiNEM::HeatmapOP}

\item{Rowv}{See function epiNEM::HeatmapOP}

\item{Colv}{See function epiNEM::HeatmapOP}

\item{dendrogram}{See function epiNEM::HeatmapOP}

\item{soft}{if TRUE, assigns weights to the expected pattern}

\item{colSideColors}{See function epiNEM::HeatmapOP}

\item{affychip}{Define Affymetrix chip used to generate the data
(optional and experimental).}

\item{method}{Scoring method can be "cosine", a correlation,
or a distance measure. See ?cor and ?dist for details.}

\item{ranks}{if TRUE, turns data into ranks}

\item{breaks}{See function epiNEM::HeatmapOP}

\item{col}{See function epiNEM::HeatmapOP}

\item{sizeFac}{Size factor penelizing the hyper-graph size.}

\item{order}{Order by "rank", "name" or "none"}

\item{verbose}{TRUE for verbose output}

\item{...}{additional arguments for epiNEM::HeatmapOP}
}
\value{
lattice object with matrix information
}
\description{
plotting the observed differential effects of an effect reporter and the
expected differential effects of the regulating signalling gene
}
\examples{
sifMatrix <- rbind(c("A", 1, "B"), c("A", 1, "C"), c("B", 1, "D"),
c("C", 1, "D"))
temp.file <- tempfile(pattern="interaction",fileext=".sif")
write.table(sifMatrix, file = temp.file, sep = "\t",
row.names = FALSE, col.names = FALSE,
quote = FALSE)
PKN <- CellNOptR::readSIF(temp.file)
CNOlist <- dummyCNOlist("A", c("B","C","D"), maxStim = 1, maxInhibit = 2,
signal = c("A", "B","C","D"))
model <- CellNOptR::preprocessing(CNOlist, PKN, maxInputsPerGate = 100)
expression <- matrix(rnorm(nrow(slot(CNOlist, "cues"))*10), 10,
nrow(slot(CNOlist, "cues")))
fc <- computeFc(CNOlist, expression)
initBstring <- rep(0, length(model$reacID))
res <- bnem(search = "greedy", CNOlist = CNOlist, fc = fc,
model = model, parallel = NULL, initBstring = initBstring, draw = FALSE,
verbose = FALSE, maxSteps = Inf)
rownames(fc) <- seq_len(nrow(fc))
val <- validateGraph(CNOlist = CNOlist, fc = fc, model = model,
bString = res$bString, Egenes = 10, Sgene = 4)
}
\author{
Martin Pirkl
}
