% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlier_analysis_functions.R
\name{make_comparison_columns}
\alias{make_comparison_columns}
\title{Utility function that will take in columns with several subcategories,
and output several columns each with binary classifications.
ex) col1: A,B,C >> colA: A,notA,notA; colB: notB,B,notB; colC: notC,notC,C}
\usage{
make_comparison_columns(intable)
}
\arguments{
\item{intable}{table where each column has more than one subcategory, can
be multiple columns}
}
\value{
an expanded table with each of the columns as a binary labeling of
    each subcategory.
}
\description{
Utility function that will take in columns with several subcategories,
and output several columns each with binary classifications.
ex) col1: A,B,C >> colA: A,notA,notA; colB: notB,B,notB; colC: notC,notC,C
}
\examples{
data("sample_annotationdata")
new_comparisons <- make_comparison_columns(
    sample_annotationdata[,1,drop=FALSE])
}
\keyword{blacksheepr}
\keyword{deva}
\keyword{outliers}
