% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biotmle.R
\name{exp_biomarkertmle}
\alias{exp_biomarkertmle}
\title{TMLE procedure using ATE for Biomarker Identication from Exposure}
\usage{
exp_biomarkertmle(Y, A, W, g_lib, Q_lib, cv_folds, ...)
}
\arguments{
\item{Y}{A \code{numeric} vector of expression values for a given biomarker.}

\item{A}{A \code{numeric} vector of discretized exposure vector (e.g., from
a design matrix whose effect on expression values is of interest.}

\item{W}{A \code{Matrix} of \code{numeric} values corresponding to baseline
covariates to be marginalized over in the estimation process.}

\item{g_lib}{A \code{character} vector identifying the library of learning
algorithms to be used in fitting the propensity score P[A = a | W].}

\item{Q_lib}{A \code{character} vector identifying the library of learning
algorithms to be used in fitting the outcome regression E[Y | A, W].}

\item{cv_folds}{A \code{numeric} scalar indicating how many folds to use in
performing targeted minimum loss estimation. Cross-validated estimates are
more robust, allowing relaxing of theoretical conditions and construction
of conservative variance estimates.}

\item{...}{Additional arguments passed to \code{\link[drtmle]{drtmle}} in
computing the targeted minimum loss estimator of the average treatment
effect.}
}
\value{
TMLE-based estimate of the relationship between biomarker expression
 and changes in an exposure variable, computed iteratively and saved in the
 \code{tmleOut} slot in a \code{biotmle} object.
}
\description{
This function performs influence curve-based estimation of the effect of an
exposure on biological expression values associated with a given biomarker,
controlling for a user-specified set of baseline covariates.
}
