% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dyNetwork.R
\name{Node_df_FreqIn}
\alias{Node_df_FreqIn}
\title{Attributes size to Nodes depending on number of interaction}
\usage{
Node_df_FreqIn(genelist, freqIn)
}
\arguments{
\item{genelist}{a vector of genes}

\item{freqIn}{dataframe with Node interaction frequencies}
}
\value{
A data frame with nodes size attributes
}
\description{
Attributes size to Nodes depending on number of interaction
}
\examples{
Node_df_FreqIn
\dontrun{
r_data <- new.env()
r_data[["FreqIn"]] <- structure(list(Genes = c("ATM", "ATR", "BRCA1", "BRCA2", "CHEK1",
"CHEK2", "FANCF", "MDC1", "RAD51"), FreqSum = c(0.04, 0.05, 0.05,
 0.03, 0.05, 0.04, 0.03, 0.03, 0.02)), .Names = c("Genes", "FreqSum"),
 class = "data.frame", row.names = c(NA, -9L))
GeneList <- whichGeneList("DNA_damage_Response")
node_df <- Node_df_FreqIn(GeneList, r_data$FreqIn)
}
}
