test_that("prepareData works", {
    expect_error(.completeInitialization(transformList = 1L, metrics = "m1"),
                 "'transformList' must be of class 'list'")

    df <- data.frame(Method = rep(c("A", "B", "C"), each = 3L),
                     Metric = rep(c("m1", "m2", "m3"), 3L),
                     Value = runif(n = 9L, min = 0.0, max = 3.0)) |>
        tidyr::spread(key = Metric, value = Value)
    df$m3 <- paste0("V", df$m3)
    metrics <- setdiff(colnames(df), "Method")
    metricInfo <- data.frame(Metric = c("m1", "m2", "m3"), num = 1L:3L)
    idInfo <- data.frame(Method = c("A", "B", "C"), lets = letters[1L:3L])

    set.seed(123L)
    pd <- .prepareData(df = df, idCol = "Method", metrics = c("m1", "m2", "m3"),
                       initialWeights = c(m1 = 0.1, m2 = 0.3, m3 = 0.5),
                       initialTransforms = list(), metricInfo = metricInfo,
                       metricColors = list(),
                       idInfo = idInfo, idColors = list(),
                       weightResolution = 0.05, metricCol = "Metric",
                       defaultWeightValue = 0.2)
    expect_type(pd, "list")
    expect_length(pd, 9L)
    expect_named(pd, c("metrics_num", "metrics_cat", "idColors",
                       "metricColors", "initialTransforms",
                       "metricsWithWeights", "initialWeights",
                       "idInfo", "metricInfo"))
    expect_identical(pd$metrics_num, c("m1", "m2"))
    expect_identical(pd$metrics_cat, "m3")
    expect_type(pd$idColors, "list")
    expect_identical(pd$idColors$lets, c(a = "lightgoldenrodyellow",
                                         b = "mediumorchid1", c = "gray26"))
    expect_identical(pd$idColors$Method, c(A = "#F8766D", B = "#00BA38", C = "#619CFF"))
    expect_type(pd$metricColors, "list")
    expect_named(pd$metricColors, c("num", "Metric"))
    expect_type(pd$metricColors$num, "closure")
    expect_identical(pd$metricColors$Metric, c(m1 = "#F8766D", m2 = "#00BA38", m3 = "#619CFF"))
    expect_type(pd$initialTransforms, "list")
    expect_length(pd$initialTransforms, 2L)
    expect_named(pd$initialTransforms, c("m1", "m2"))
    expect_type(pd$initialTransforms$m1, "list")
    expect_identical(pd$initialTransforms$m1, pd$initialTransforms$m2)
    expect_type(pd$initialTransforms$m1, "list")
    expect_length(pd$initialTransforms$m1, 4L)
    expect_named(pd$initialTransforms$m1, c("offset", "flip", "cuts", "transform"))
    expect_type(pd$metricsWithWeights, "character")
    expect_identical(pd$metricsWithWeights, c("m1", "m2", "m3", "Metric_m1",
                                              "Metric_m2", "Metric_m3",
                                              "num_1", "num_2", "num_3"))
    expect_identical(pd$initialWeights, c(m1 = 0.1, m2 = 0.3, m3 = 0.5,
                                          Metric_m1 = 0.2, Metric_m2 = 0.2,
                                          Metric_m3 = 0.2, num_1 = 0.2,
                                          num_2 = 0.2, num_3 = 0.2))
    expect_identical(pd$idInfo, idInfo)
    expect_identical(pd$metricInfo, metricInfo)

    set.seed(345L)
    pd <- .prepareData(df = df, idCol = "Method", metrics = c("m1", "m2", "m3"),
                       initialWeights = NULL,
                       initialTransforms = list(m1 = list(offset = 4.0),
                                                m2 = list(flip = TRUE)),
                       metricInfo = metricInfo[, 1L, drop = FALSE],
                       metricColors = list(),
                       idInfo = idInfo,
                       idColors = list(Method = c(A = "blue", B = "green", C = "yellow")),
                       weightResolution = 0.05, metricCol = "Metric",
                       defaultWeightValue = 0.2)
    expect_type(pd, "list")
    expect_length(pd, 9L)
    expect_named(pd, c("metrics_num", "metrics_cat", "idColors",
                       "metricColors", "initialTransforms",
                       "metricsWithWeights", "initialWeights",
                       "idInfo", "metricInfo"))
    expect_identical(pd$metrics_num, c("m1", "m2"))
    expect_identical(pd$metrics_cat, "m3")
    expect_type(pd$idColors, "list")
    expect_identical(pd$idColors$lets, c(a = "slategray", b = "lightskyblue4", c = "grey79"))
    expect_identical(pd$idColors$Method, c(A = "blue", B = "green", C = "yellow"))
    expect_type(pd$metricColors, "list")
    expect_named(pd$metricColors, "Metric")
    expect_identical(pd$metricColors$Metric, c(m1 = "#F8766D", m2 = "#00BA38", m3 = "#619CFF"))
    expect_type(pd$initialTransforms, "list")
    expect_length(pd$initialTransforms, 2L)
    expect_named(pd$initialTransforms, c("m1", "m2"))
    expect_type(pd$initialTransforms$m1, "list")
    expect_identical(pd$initialTransforms$m1$offset, 4.0)
    expect_false(pd$initialTransforms$m1$flip)
    expect_identical(pd$initialTransforms$m2$offset, 0.0)
    expect_true(pd$initialTransforms$m2$flip)
    expect_type(pd$initialTransforms$m1, "list")
    expect_length(pd$initialTransforms$m1, 4L)
    expect_named(pd$initialTransforms$m1, c("offset", "flip", "cuts", "transform"))
    expect_type(pd$metricsWithWeights, "character")
    expect_identical(pd$metricsWithWeights, c("m1", "m2", "m3"))
    expect_identical(pd$initialWeights, c(m1 = 0.2, m2 = 0.2, m3 = 0.2))
    expect_identical(pd$idInfo, idInfo)
    expect_null(pd$metricInfo)

    set.seed(678L)
    pd <- .prepareData(df = df, idCol = "Method", metrics = c("m1", "m2", "m3"),
                       initialWeights = NULL,
                       initialTransforms = list(m1 = list(offset = 4.0),
                                                m2 = list(flip = TRUE)),
                       metricInfo = metricInfo[, 1L, drop = FALSE],
                       metricColors = list(),
                       idInfo = idInfo[, 1L, drop = FALSE],
                       idColors = list(Method = c(A = "blue", B = "green", C = "yellow")),
                       weightResolution = 0.05, metricCol = "Metric",
                       defaultWeightValue = 0.2)
    expect_type(pd, "list")
    expect_length(pd, 9L)
    expect_named(pd, c("metrics_num", "metrics_cat", "idColors",
                       "metricColors", "initialTransforms",
                       "metricsWithWeights", "initialWeights",
                       "idInfo", "metricInfo"))
    expect_identical(pd$metrics_num, c("m1", "m2"))
    expect_identical(pd$metrics_cat, "m3")
    expect_type(pd$idColors, "list")
    expect_identical(pd$idColors$Method, c(A = "blue", B = "green", C = "yellow"))
    expect_type(pd$metricColors, "list")
    expect_named(pd$metricColors, "Metric")
    expect_identical(pd$metricColors$Metric, c(m1 = "#F8766D", m2 = "#00BA38", m3 = "#619CFF"))
    expect_type(pd$initialTransforms, "list")
    expect_length(pd$initialTransforms, 2L)
    expect_named(pd$initialTransforms, c("m1", "m2"))
    expect_type(pd$initialTransforms$m1, "list")
    expect_identical(pd$initialTransforms$m1$offset, 4.0)
    expect_false(pd$initialTransforms$m1$flip)
    expect_identical(pd$initialTransforms$m2$offset, 0.0)
    expect_true(pd$initialTransforms$m2$flip)
    expect_type(pd$initialTransforms$m1, "list")
    expect_length(pd$initialTransforms$m1, 4L)
    expect_named(pd$initialTransforms$m1, c("offset", "flip", "cuts", "transform"))
    expect_type(pd$metricsWithWeights, "character")
    expect_identical(pd$metricsWithWeights, c("m1", "m2", "m3"))
    expect_identical(pd$initialWeights, c(m1 = 0.2, m2 = 0.2, m3 = 0.2))
    expect_null(pd$idInfo)
    expect_null(pd$metricInfo)
})
