% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PRIOR_FUNCTIONS.R
\name{BB_Fun}
\alias{BB_Fun}
\title{Estimating size for each gene by
either 1D or 2D maximization of marginal distribution}
\usage{
BB_Fun(
  Data,
  BETA_vec,
  INITIAL_MU_vec,
  INITIAL_SIZE_vec,
  MU_lower = 0.01,
  MU_upper = 500,
  SIZE_lower = 0.01,
  SIZE_upper = 30,
  parallel = FALSE,
  NCores = 5,
  FIX_MU = TRUE,
  GR = FALSE
)
}
\arguments{
\item{Data}{A matrix of single-cell expression where rows
are genes and columns are samples (cells). \code{Data}
can be of class \code{SummarizedExperiment} (the
assays slot contains the expression matrix,
is named "Counts"), just \code{matrix} or sparse matrix.}

\item{BETA_vec}{A vector of capture efficiencies
(probabilities) of cells.}

\item{INITIAL_MU_vec}{Mean expression of genes,
can be estimated from \code{EstPrior}.}

\item{INITIAL_SIZE_vec}{size of genes (size is a parameter in
NB distribution), can come from EstPrior.}

\item{MU_lower}{The lower bound for the mu.(Only need it when
you want to do 2D optimization). Default is 0.01.}

\item{MU_upper}{The upper bound for the mu.(Only need it when
you want to do 2D optimization). Default is 500.}

\item{SIZE_lower}{The lower bound for the size. Default is 0.01.}

\item{SIZE_upper}{The upper bound for the size. Default is 30.}

\item{parallel}{If TRUE, \code{NCores} cores
will be used for parallelization. Default is TRUE.}

\item{NCores}{number of cores to use, default is 5. This will
be used to set up a parallel environment using either
MulticoreParam (Linux, Mac) or SnowParam (Windows) with NCores
using the package BiocParallel.}

\item{FIX_MU}{If TRUE, then 1D optimization, otherwise 2D
optimization (slow).}

\item{GR}{If TRUE, the gradient function will be used in
optimization. However since the gradient function itself is
very complicated, it does not help too much in speeding up.
Default is FALSE.}
}
\value{
BB estimated size (1D optimization) or size and mu (2D optimization).
}
\description{
Estimating parameters of the prior distribution
for each gene by maximizing marginal distribution: 1D
(optimize with respect to size using MME estimate of mu,
2D (optimize with respect to both mu and size)
}
\examples{
data('EXAMPLE_DATA_list')
BB_RESULT<-BB_Fun(Data=EXAMPLE_DATA_list$inputdata[,seq(1,30)],
BETA_vec = EXAMPLE_DATA_list$inputbeta[seq(1,30)],
INITIAL_MU_vec=EXAMPLE_DATA_list$mu,
INITIAL_SIZE_vec=EXAMPLE_DATA_list$size,
MU_lower=0.01,MU_upper=500,SIZE_lower=0.01,
SIZE_upper=30,parallel=FALSE,NCores=5,FIX_MU=TRUE,GR=FALSE)


}
