% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BasiliskEnvironment.R
\docType{class}
\name{BasiliskEnvironment-class}
\alias{BasiliskEnvironment-class}
\alias{BasiliskEnvironment}
\title{The BasiliskEnvironment class}
\description{
The BasiliskEnvironment class provides a simple structure 
containing all of the information to construct a \pkg{basilisk} environment.
It is used by \code{\link{basiliskStart}} to perform lazy installation.
}
\section{Constructor}{

\code{BasiliskEnvironment(envname, pkgname, packages)} will return a BasiliskEnvironment object, given:
\itemize{
\item \code{envname}, string containing the name of the environment.
Environment names starting with an underscore are reserved for internal use.
\item \code{pkgname}, string containing the name of the package that owns the environment.
\item \code{packages}, character vector containing the names of the required Python packages from PyPI.
see \code{\link{setupBasiliskEnv}} for requirements.
\item \code{channels}, deprecated and ignored.
\item \code{pip}, appended to \code{packages}.
Provided for back-compatibility only.
\item \code{paths}, character vector containing relative paths to Python packages to be installed via \code{pip}.
These paths are interpreted relative to the system directory of \code{pkgname},
i.e., they are appended to the output of \code{\link{system.file}} to obtain absolute paths for \code{\link{setupBasiliskEnv}}.
Thus, any Python package vendored into the R package should be stored in the \code{inst} directory of the latter's source.
}
}

\examples{
BasiliskEnvironment("my_env1", "AaronPackage", 
    packages=c("scikit-learn=1.6.1", "pandas=2.2.3"))
}
\author{
Aaron lun
}
