% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processIlluminaSamplesheets_Functions.R
\docType{methods}
\name{validateBCLSheet}
\alias{validateBCLSheet}
\title{Illumina sample sheet cleaning and updating for
bcl2Fastq versions >= 2.1.7}
\usage{
validateBCLSheet(sampleSheet, param = bcl2fastqparams)
}
\arguments{
\item{sampleSheet}{File location of a sample sheet for Illumina basecalling using bcl2Fastq (See vignette for more details).}

\item{param}{A BCL2FastQparams object}
}
\value{
cleanedSampleSheet A data.frame containing the cleaned sample sheet for
 Illumina basecalling using bcl2Fastq versions >= 2.1.7.
}
\description{
Parses an Illumina bcl2Fastq sample sheet  to create a
standardised/updated sample sheet for bcl2Fastq >= Version 2.1.7
}
\examples{

fileLocations <- system.file("extdata",package="basecallQC")
runXML <- dir(fileLocations,pattern="runParameters.xml",full.names=TRUE)
config <- dir(fileLocations,pattern="config.ini",full.names=TRUE)
sampleSheet <- dir(fileLocations,pattern="*\\\\.csv",full.names=TRUE)
bcl2fastqparams <- BCL2FastQparams(runXML,config,runDir=getwd(),verbose=FALSE)
cleanedSampleSheet <- validateBCLSheet(sampleSheet,param=bcl2fastqparams)

}
\author{
Thomas Carroll and Marian Dore
}
