% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandle-function.R
\name{bandlePredict}
\alias{bandlePredict}
\title{Make predictions from a bandle analysis}
\usage{
bandlePredict(objectCond1, objectCond2, params, fcol = "markers")
}
\arguments{
\item{objectCond1}{A list of instances of class \code{\link[MSnbase:MSnSet-class]{MSnbase::MSnSet}}s
where each is an experimental replicate for the first condition, usually a control}

\item{objectCond2}{A list of instance of class \code{\link[MSnbase:MSnSet-class]{MSnbase::MSnSet}}s
where each is an experimental replicate for the second condition, usually a treatment}

\item{params}{An instance of class \code{bandleParams}, as generated by
\code{\link[=bandle]{bandle()}}.}

\item{fcol}{A feature column indicating the markers. Defaults to "markers"}
}
\value{
\code{bandlePredict} returns an instance of class
\code{\link[MSnbase:MSnSet-class]{MSnbase::MSnSet}} containing the localisation predictions as
a new \code{bandle.allocation} feature variable. The allocation
probability is encoded as \code{bandle.probability}
(corresponding to the mean of the distribution
probability). In addition the upper and lower quantiles of
the allocation probability distribution are available as
\code{bandle.probability.lowerquantile} and
\code{bandle.probability.upperquantile} feature variables. The
Shannon entropy is available in the \code{bandle.mean.shannon}
feature variable, measuring the uncertainty in the allocations
(a high value representing high uncertainty; the highest value
is the natural logarithm of the number of classes). An additional variable
indicating the differential localization probability is also added as
\code{bandle.differential.localisation}
}
\description{
Make predictions from a bandle analysis
}
\examples{
library(pRolocdata)
data("tan2009r1")
set.seed(1)
tansim <- sim_dynamic(object = tan2009r1, 
                    numRep = 6L,
                   numDyn = 100L)
gpParams <- lapply(tansim$lopitrep, function(x) 
fitGPmaternPC(x, hyppar = matrix(c(0.5, 1, 100), nrow = 1)))
d1 <- tansim$lopitrep
control1 <- d1[1:3]
treatment1 <- d1[4:6]
mcmc1 <- bandle(objectCond1 = control1, objectCond2 = treatment1, gpParams = gpParams,
                                     fcol = "markers", numIter = 5L, burnin = 1L, thin = 2L,
                                     numChains = 1, BPPARAM = SerialParam(RNGseed = 1))
mcmc1 <- bandleProcess(mcmc1)
out <- bandlePredict(objectCond1 = control1, objectCond2 = treatment1, params = mcmc1)
}
