% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandle-sampling-utils.R
\name{proteinAllocation}
\alias{proteinAllocation}
\alias{outlierAllocationProbs}
\alias{sampleOutlier}
\alias{covOrganelle}
\alias{pg_prior}
\alias{sample_weights_pg}
\alias{sample_weights_dir}
\title{sample allocations, probabilities and compute loglikilihoods}
\usage{
proteinAllocation(loglikelihoods, currentweights, alloctemp, cond)

outlierAllocationProbs(
  outlierlikelihood,
  loglikelihoods,
  epsilon,
  alloctemp,
  cond
)

sampleOutlier(allocoutlierprob)

covOrganelle(object, fcol = "markers")

pg_prior(object_cond1, object_cond2, K, pgPrior = NULL, fcol = "markers")

sample_weights_pg(nk_mat, pgPrior, w, K, tau = 0.2)

sample_weights_dir(nk_mat, dirPrior)
}
\arguments{
\item{loglikelihoods}{the log likelihoods}

\item{currentweights}{the current allocations weights}

\item{alloctemp}{the current protein allocations}

\item{cond}{the control = 1, treatment = 2}

\item{outlierlikelihood}{the outlier log likelihoods}

\item{epsilon}{the outlier component weight}

\item{allocoutlierprob}{the outlier probabilities}

\item{object}{An instance of class \code{MSnSet}}

\item{fcol}{The feature column containing the markers.}

\item{object_cond1}{A list of instance of class \code{MSnSets} usually control}

\item{object_cond2}{A list of instance of class \code{MSnSets} usually treatment}

\item{K}{The number of organelle classes}

\item{pgPrior}{The Polya-Gamma prior}

\item{nk_mat}{The summary matrix of allocations}

\item{w}{The Polya-Gamma auxiliary variable}

\item{tau}{The empirical bayes parameter for the Polya-Gamma variable.
Defaults to 0.2.}

\item{dirPrior}{The Dirichlet prior}
}
\value{
returns samples for protein allocations, log likelihoods and probabilities

returns outlier probabilities

returns outlier allocations

returns covariance of organelles using marker proteins

returns the Polya-Gamma prior

returns A sample of the weights using Polya-Gamma priors.

returns A sample of the weights using Dirichlet prior.
}
\description{
Internal sampling function, not for outside use documented for completness
}
\examples{
library(pRolocdata)
data("tan2009r1")
covOrganelle(object = tan2009r1)


library(pRolocdata)
data("tan2009r1")
set.seed(1)
tansim <- sim_dynamic(object = tan2009r1, 
                    numRep = 6L,
                   numDyn = 100L)
d1 <- tansim$lopitrep
control1 <- d1[1:3]
treatment1 <- d1[4:6]
out <- pg_prior(object_cond1 = control1,
 object_cond2 = treatment1, K = 11) 


}
