% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_filter.R
\name{pvalues_estimable}
\alias{pvalues_estimable}
\alias{coefs_estimable}
\title{Are coefs/pvalues estimable}
\usage{
pvalues_estimable(formula, data)

coefs_estimable(formula, data)
}
\arguments{
\item{formula}{formula}

\item{data}{data.table}
}
\description{
Are coefs/pvalues estimable
}
\examples{
# Onevar design
# -------------
    # Design not full rank, coefficients/pvalues not estimable
         (dt <- data.table( time = factor(c('t0', 't1', 't2', 't3'  ) ), 
                           value =        c(  0,    1,    2,   NA   ) ))
            coefs_estimable(~time, data = dt)
          pvalues_estimable(~time, data = dt)
            summary(lm(value~time, data = dt))

    # Design full rank, coefficients estimable.
    # No residual dof, pvalues not estimable.
         (dt <- data.table( time = factor(c('t0', 't1', 't2', 't3'  ) ), 
                           value =        c(  0,    1,    2,    3   ) ))
            coefs_estimable(~time, data = dt)
          pvalues_estimable(~time, data = dt)
            summary(lm(value~time, data = dt))

    # Design full rank, coefficients estimable
    # Residual dof, pvalues estimable
         (dt <- data.table( time = factor(c('t0', 't1', 't2', 't3', 't3' ) ), 
                           value =        c(  0,    1,    2,    3,    3.1) ))
            coefs_estimable(~time, data = dt)
          pvalues_estimable(~time, data = dt)
          summary(lm(value~time, data = dt))

# Twovar design
# -------------
    # Design not full rank, coefficients/pvalues not estimable.
         (dt <- data.table( time = factor(c(  't0',  't1', 't2', 't2','t3',  't3',  't0', 't1', 't2', 't3' ) ), 
                        diabetes = factor(c(   'C',  'C',  'C',  'C',  'C',   'C',   'D',  'D',  'D',  'D'  ) ),
                           value =        c(    0,    1,    2,    2.1,  3,    3.1,   NA,   NA,   NA,   NA  ) ))
            coefs_estimable(~time+diabetes, data = dt)
          pvalues_estimable(~time+diabetes, data = dt)
          # summary(lm(value~time+diabetes, data = dt))

    # Design full rank, coefficients estimable
    # No residual dof, pvalues not estimable
         (dt <- data.table( time = factor(c( 't0', 't1', 't2', 't3',  't0', 't1', 't2', 't3' ) ), 
                        diabetes = factor(c(  'C', 'C',  'C',  'C',   'D',  'D',  'D',  'D'  ) ),
                           value =        c(   0,   1,    2,   3,      0.5,  NA,   NA,   NA  ) ))
            coefs_estimable(~time+diabetes, data = dt)
          pvalues_estimable(~time+diabetes, data = dt)
            summary(lm(value~time+diabetes, data = dt))

    # Design full rank, coefficients estimable
    # Residual dof, pvalues estimable
         (dt <- data.table( time = factor(c( 't0', 't1', 't2', 't3',  't0', 't1', 't2', 't3' ) ), 
                        diabetes = factor(c(  'C', 'C',  'C',  'C',   'D',  'D',  'D',  'D'  ) ),
                           value =        c(   0,    1,    2,   3,     0.5,  1.6,  NA,   NA  ) ))
            coefs_estimable(~time+diabetes, data = dt)
          pvalues_estimable(~time+diabetes, data = dt)
            summary(lm(value~time+diabetes, data = dt))
}
