% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/25_linmod_limma.R
\name{plot_fit_summary}
\alias{plot_fit_summary}
\title{Plot fit summary}
\usage{
plot_fit_summary(sumdt, nrow = NULL, ncol = NULL, order = FALSE)
}
\arguments{
\item{sumdt}{data.table}

\item{nrow}{number}

\item{ncol}{number}

\item{order}{TRUE or FALSE}
}
\description{
Plot fit summary
}
\examples{
file <- system.file('extdata/atkin.metabolon.xlsx', package = 'autonomics')
object <- read_metabolon(file)
object \%<>\% linmod_lm()
object \%<>\% linmod_limma(block = 'Subject')
sumdt <- summarize_fit(object, coefs = c('t1-t0', 't2-t0', 't3-t0'))
plot_fit_summary(sumdt)
}
