% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/33_survival.R
\name{.fit_survival}
\alias{.fit_survival}
\alias{fit_survival}
\alias{prep_survival}
\alias{plot_survival}
\title{Fit/Plot survival}
\usage{
.fit_survival(
  object,
  formula = as.formula(sprintf("~\%s", assayNames(object)[1])),
  coefs = NULL,
  engine = c("coxph", "survdiff", "logrank")[1],
  drop = TRUE,
  coding = "code_control",
  verbose = TRUE
)

fit_survival(
  object,
  formula = as.formula(sprintf("~\%s", assayNames(object)[1])),
  engine = c("coxph", "survdiff", "logrank")[1],
  drop = TRUE,
  coding = "code_control",
  coefs = NULL,
  verbose = TRUE,
  outdir = NULL,
  plot = FALSE,
  order = coefs(object, fit = engine)[1],
  stats = coefs(object, fit = engine),
  dodge = 0,
  n = if (svar_formula(formula, object)) 1 else min(nrow(object), 2),
  n_col = n \%>\% min(nrow(object)) \%>\% sqrt() \%>\% ceiling() \%>\% min(4),
  n_row = n \%>\% min(ncol(object)) \%>\% sqrt() \%>\% floor() \%>\% min(4),
  width = 3 * n_col,
  height = 3 * n_row,
  writefunname = "write_xl"
)

prep_survival(
  object,
  formula = as.formula(sprintf("~\%s", assayNames(object)[1])),
  assaylevels = NULL,
  engine = c("coxph", "survdiff", "logrank") \%>\% intersect(fits(object)) \%>\%
    extract(1),
  order = autonomics::coefs(object, fit = engine)[1],
  stats = autonomics::coefs(object, fit = engine),
  n = if (svar_formula(formula, object)) 1 else min(nrow(object), 9)
)

plot_survival(
  object,
  formula = as.formula(sprintf("~\%s", assayNames(object)[1])),
  assaylevels = NULL,
  engine = c("coxph", "survdiff", "logrank") \%>\% intersect(fits(object)) \%>\%
    extract(1),
  order = autonomics::coefs(object, fit = engine)[1],
  stats = autonomics::coefs(object, fit = engine),
  title = sprintf("\%s ~ \%s", engine, formula2str(formula) \%>\% substr(2, nchar(.))),
  dodge = 0,
  file = NULL,
  n = if (svar_formula(formula, object)) 1 else min(nrow(object), 4),
  n_col = n \%>\% min(nrow(object)) \%>\% sqrt() \%>\% ceiling() \%>\% min(4),
  n_row = n \%>\% min(ncol(object)) \%>\% sqrt() \%>\% floor() \%>\% min(4),
  width = 3 * n_col,
  height = 3 * n_row
)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{formula}{model formula: contains svars/assayNames}

\item{coefs}{NULL or character (coefs to be stored in object)}

\item{engine}{'coxph', 'survdiff' or 'logrank'}

\item{drop}{TRUE or FALSE : whether to drop var in coefname}

\item{coding}{string: codingfunname}

\item{verbose}{TRUE or FALSE}

\item{outdir}{output directory}

\item{plot}{TRUE or FALSE}

\item{order}{NULL/character (coefs to order plots on)}

\item{stats}{coefs to print stats for}

\item{dodge}{number}

\item{n}{number of features to plot}

\item{n_col}{number of columns}

\item{n_row}{number of rows}

\item{width}{number}

\item{height}{number}

\item{writefunname}{'write_xl' or 'write_ods'}

\item{assaylevels}{NULL or vector: assaylevels to be used (for plotting)}

\item{title}{string}

\item{file}{filepath}
}
\value{
SummarizedExperiment/ggplot
}
\description{
Fit/Plot survival
}
\examples{
# Formula
    # Samplevar-based
          fit_survival(survobj(), ~age)           # age
          fit_survival(survobj(), ~sex)           # sex
          fit_survival(survobj(), ~age + sex)     # age across  sexlevels, sex across agelevels
          fit_survival(survobj(), ~age / sex)     # sex within  agelevel
          fit_survival(survobj(), ~age * sex)     # sex between agelevels (=age between sexlevels)
  
    # Assayvar-based
          fit_survival(survobj(), ~exprs)         #   numerical coding
          fit_survival(survobj(), ~exprs2bins)    #     integer coding
          fit_survival(survobj(), ~exprs2levels)  # categorical coding

    # Samplevar/Assayvar-based
          fit_survival(survobj(), ~age+exprs2levels, order = 'senior-junior'          ) #  age effect across exprlevels
          fit_survival(survobj(), ~age+exprs2levels, order = '2-1'                    ) # expr effect across agelevels
          fit_survival(survobj(), ~age/exprs2levels, order = 'senior:2-1'             ) # expr effect within agelevel
          fit_survival(survobj(), ~age*exprs2levels, order = 'senior-junior:2-1'      ) # expr effect differences between agelevels (or vice versa)
  
# Other arguments
    # engine: 'coxph' -> 'survdiff'
          fit_survival(survobj(), ~ exprs2levels)                        # coxph
          fit_survival(survobj(), ~ exprs2levels, engine = 'survdiff')   # survdiff

    # drop: drop varname in coefnames -> dont
          fit_survival(survobj(), ~ exprs2levels)                # 2-1
          fit_survival(survobj(), ~ exprs2levels, drop = FALSE)  # exprs2levels2-1

    # coding: code_control -> contr.treatment
          fit_survival(survobj(), ~ exprs2levels)                             # code_control
          fit_survival(survobj(), ~ exprs2levels, coding = 'contr.treatment') # contr.treatment

    # outdir: print to object/screen -> print to xlsx/pdf
          fit_survival(survobj(), ~ exprs2levels)                                                 # print to object/screen
          fit_survival(survobj(), ~ exprs2levels, outdir = tempdir())                             # print to   xlsx/pdf
          fit_survival(survobj(), ~ exprs2levels, outdir = tempdir(), writefunname = 'write_ods') # print to    ods/pdf

    # plot: plot -> dont
          fit_survival(survobj(), ~ exprs2levels)                # plot
          fit_survival(survobj(), ~ exprs2levels, plot = FALSE)  # dont

    # order: order on first coef -> order on custom coef
          fit_survival(survobj(), ~ age+exprs2levels)                  # order on 'senior-junior'
          fit_survival(survobj(), ~ age+exprs2levels, order = '2-1')   # order on '2-1'

    # stats: show stats for all coefs -> show stats for custom coefs
          fit_survival(survobj(), ~ age+exprs2levels)                          # show stats for 'senior-junior' and 'bin2-bin1'
          fit_survival(survobj(), ~ age+exprs2levels, stats = 'senior-junior') # show stats for 'senior-junior'

    # dodge: overlap curves -> dodge curves
          fit_survival(survobj(), ~ age+exprs2levels)            # overlap curves
          fit_survival(survobj(), ~ age+exprs2levels, dodge = 2) # dodge curves

    # n: (plot) top2 -> top4
          fit_survival(survobj(), ~ age+exprs2levels)         # top2
          fit_survival(survobj(), ~ age+exprs2levels, n = 4)  # top4

    # n_row n_col: 1 row 2 col -> 2 row 1 col
          fit_survival(survobj(), ~ age+exprs2levels)                       # 1 row 2 col
          fit_survival(survobj(), ~ age+exprs2levels, n_row = 2, n_col = 1) # 2 row 1 col
}
