% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotations.R
\name{annotateTEsGetters}
\alias{annotateTEsGetters}
\alias{getLTRs}
\alias{getLINEs}
\alias{getSINEs}
\alias{getDNAtransposons}
\title{Getter functions of TE classes from parsed RepeatMasker annotations.}
\usage{
getLTRs(
  annot,
  relLength = 0.9,
  fullLength = TRUE,
  partial = FALSE,
  soloLTR = FALSE,
  otherLTR = FALSE,
  returnMask = FALSE
)

getLINEs(annot, relLength = 0.9, returnMask = FALSE)

getSINEs(annot, relLength = 0.9, returnMask = FALSE)

getDNAtransposons(annot, relLength = 0.9, returnMask = FALSE)
}
\arguments{
\item{annot}{A [`GRanges`][GenomicRanges::GRanges-class] or
[`GRangesList`][GenomicRanges::GRangesList-class] object obtained
with the function `annotaTES()`, using either [`OneCodeToFindThemAll`]
or [`rmskatenaparser`] as RepeatMasker parser functions.
Alternatively, if `annot` is a [`QuantifyParam`] or a
[`SummarizedExperiment`][SummarizedExperiment::SummarizedExperiment-class]
object produced by the `qtex()` function, this function will
attempt to extract the corresponding annotations from inside
those objects.}

\item{relLength}{(Default 0.9) Numeric value that can take values between 0
to 1. Sets the minimum relative length required for
features. Elements with a lower relative length than
\code{relLength} will be filtered. The relative length
used is the one obtained by \code{OneCodeToFindThemAll()}
or \code{rmskatenaparser()}.
(length of the reconstructed TE / length of the reference).}

\item{fullLength}{(Default TRUE) Logical value on whether reconstructed
full-length LTR TEs (elements with structure 
LTR - internal region - LTR) should be selected.}

\item{partial}{(Default FALSE) Logical value on whether partially
reconstructed LTR TEs should be selected (structure LTR -
internal region or internal region - LTR).}

\item{soloLTR}{(Default FALSE) Logical value on whether solo LTRs should be
selected. Note that only fragments unambiguously identified
as LTRs thanks to the identification of their equivalent
internal region are considered as LTRs.}

\item{otherLTR}{(Default FALSE) Logical value on whether other TEs from the
LTR class, not included in any of the previous three
categories, should be selected. These include TEs from LTR
class that cannot be unambiguously identified as LTR o
internal region, and thus cannot be reconstructed into
partial or full-length elements; as well as solo internal
regions.}

\item{returnMask}{(Default FALSE) Logical value indicating whether a subset
of the input annotations should be returned (default) or
a logical mask of the same length as the input annotations
where \code{TRUE} values indicate what annotations belong
to the TE class we want to obtain with the getter function.}
}
\value{
A [`GRangesList`][GenomicRanges::GRangesList-class] object with
        annotations from class corresponding to the getter function (LTRs,
        LINEs, SINEs or DNA transposons).
}
\description{
Getter functions of TE classes from parsed RepeatMasker annotations.
}
\details{
Retrieves annotations from the TE class corresponding to the getter function,
using RepeatMasker annotations after parsing them with the
\code{OneCodeToFindThemAll()} or \code{rmskatenaparser()} function. The
\code{relLength} parameter can be used to filter out elements with a lower
relative length. Further parameters can be used to fine-tune the type of
elements to be reported.
}
\examples{
rmskat <- annotaTEs(genome="dm6", parsefun=rmskatenaparser,
                    strict=FALSE)

rmskatLTR <- getLTRs(rmskat, relLength=0.95, fullLength=TRUE,
                     partial=TRUE)
rmskatLTR
 
rmskat_line <- getLINEs(rmskat, relLength=0.95)
 
rmskat_sine <- getSINEs(rmskat, relLength=0.95)
 
rmskat_DNAtrans <- getDNAtransposons(rmskat, relLength=0.95)
 
}
