% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictPatientRisk.R
\name{predict_PatientRisk}
\alias{predict_PatientRisk}
\title{Predict Patient Risk Based on Gene Expression Data}
\usage{
predict_PatientRisk(model.fit, mExpr.testData)
}
\arguments{
\item{model.fit}{A list containing the pre-fitted model and necessary 
parameters for risk prediction, including the optimal lambda value, risk 
thresholds, and plot values.}

\item{mExpr.testData}{A data frame representing the gene expression data of 
test patients, where each row is a gene and each column is a sample.}
}
\value{
A list containing the following elements:
\itemize{
 \item{\code{risk_score}: A vector with the unscaled risk score for new 
 patients estimated by a multivariate Cox regression model.}
 \item{\code{scaled_risk_score}:  A vector with the risk score for the new 
 patients scaled to be interpretable in the range 0-100.}
 \item{\code{plot_values}: A list containing information for visualizing the 
 sigmoid curve and risk thresholds.}
 }
}
\description{
Function to predict the risk for new patients considering the gene 
expression for a subset of genes and the multivariate Cox regression model 
trained by function patientRisk, it may be used to predict over a single 
patient.
}
\details{
A risk score is estimated for new patients considering the optimal 
regularized multivariate Cox regression model trained by the function 
patientRisk. The risk score is normalized to be interpretable in the 
scale (0-100). The function generates a risk plot for new patients and 
stratifies them in three risk groups (low, intermediate, high) considering 
the thresholds learned by function patientRisk.
}
\examples{
data(seBRCA)

# prefilterSAM ---
data(ex_prefilterSAM)

# genePheno ---
data(ex_genePheno)

# patientRisk ---
data(ex_patientRisk)
                                           
# Simulate expression data
num_samples <- 20
geneList <- names(ex_genePheno$genes)
set.seed(5)
mExprs_testData <- matrix(rnorm(length(geneList) * num_samples, 
                          mean = 10, sd = 3),
                          nrow = length(geneList), ncol = num_samples)

# Assign row names (genes) and column names (samples)
rownames(mExprs_testData) <- geneList
colnames(mExprs_testData) <- paste0("Sample", 1:num_samples)

set.seed(5)
risk_prediction_validation_set <- predict_PatientRisk(
                                                ex_patientRisk, 
                                                mExprs_testData)


# Example for single patient prediction: Patient fourth is selected.
ex_predictPatientRisk <- data.frame(mExprs_testData[, 4])
colnames(ex_predictPatientRisk) <- colnames(mExprs_testData)[4]
# Risk prediction for the optimal subset of genes selected by patientRisk() 
set.seed(5)
risk_prediction_one_patient <- predict_PatientRisk(
                                                ex_patientRisk, 
                                                ex_predictPatientRisk)

}
\references{
\itemize{
  \item{\insertRef{martinezromero2018}{asuri}} 
  \item{\insertRef{BuenoFortes2023}{asuri}}
}
}
