% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFunctions.R
\name{plotProbClass}
\alias{plotProbClass}
\title{Plot a class probability distribution for geneSurv()}
\usage{
plotProbClass(gs_result)
}
\arguments{
\item{gs_result}{Returning object from running geneSurv function}
}
\value{
Plot of the class probability distribution across samples 
for geneSurv()
}
\description{
This function is called internally by the geneSurv function to generate the
probability class distribution of the patients. It also can be used after 
the function has been run to generate the plots again without 
running geneSurv().
}
\examples{
data(seBRCA)
time <- "time"
status <- "status"
geneName <- "ESR1"
# The TIME value must be transformed to YEARS
# The gene expression vector must be provided with the NAMES of each sample,
# that should match the time and status NAMES.
set.seed(5)
outputKM <- geneSurv(seBRCA, time, status, geneName, type = "exprs")

# Generate the plots again
## Plots for c(type = exprs)
plotProbClass(outputKM)

}
\seealso{
\code{\link{geneSurv}} for more information about the analysis
}
