% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ev.R
\name{ev}
\alias{ev}
\title{Compute expression variability measure}
\usage{
ev(x, cutoff = NULL, plot = FALSE, ...)
}
\arguments{
\item{x}{matrix of gene expression, with one column per sample}

\item{cutoff}{minimum expression value to be included in computation (for \code{frma} normalized data, we find 2.54 to be a good value for determining if a probeset is expressed in a given sample (default NULL)}

\item{plot}{make a plot of local likelihood model using \code{smoothScatter} (default=FALSE)}

\item{...}{arguments passed to \code{smoothScatter}}
}
\value{
numeric vector of length equal to number of rows of \code{x}
}
\description{
This function computes expression variability in a way that
removes dependence on mean expression.
It uses a local polynomial likelihood method to estimate variance
as gamma distributed around given mean expression for each probeset.
This function makes this calculation using all samples in argument. To
calculate expression variability for samples in different groups, call this
function for each subset of columns separately.
}
\examples{
if (require(antiProfilesData)) {
  data(apColonData)
  e <- exprs(apColonData)[,pData(apColonData)$Status==1]
  ev <- ev(e, cutoff=2.54)
}

}
\author{
Hector Corrada Bravo \email{hcorrada@gmail.com}
}
\references{
E. Alemu, H. Corrada Bravo, S. Hannenhalli (2014). Determinants of Expression Variability. Nucleic Acids Research, 42 (6), 3503-14.
}
\seealso{
\code{frma} for normalization
}

