% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize.R
\name{summarize_categorical}
\alias{summarize_categorical}
\title{Summarize categorical data over groupings of annotated regions}
\usage{
summarize_categorical(
  annotated_regions,
  by = c("annot.type", "annot.id"),
  quiet = FALSE
)
}
\arguments{
\item{annotated_regions}{The \code{GRanges} result of \code{annotate_regions()}.}

\item{by}{A character vector to group the data in \code{as.data.frame(annotated_regions)} by and tally over. Default is \code{c('annot.type', 'annot.id')}.}

\item{quiet}{Print progress messages (FALSE) or not (TRUE).}
}
\value{
A grouped \code{dplyr::tbl_df} of the counts of groupings according to the \code{by} vector.
}
\description{
Given a \code{GRanges} of annotated regions, count the number of regions when the annotations are grouped \code{by} categorical columns.
}
\details{
If a region is annotated to multiple annotations of the same \code{annot.type}, the region will only be counted once. For example, if a region were annotated to multiple exons, it would only count once toward the exons, but if it were annotated to an exon and an intron, it would count towards both.
}
\examples{

   # Get premade CpG annotations
   data('annotations', package = 'annotatr')

   r_file = system.file('extdata', 'test_read_multiple_data_nohead.bed', package='annotatr')
   extraCols = c(pval = 'numeric', mu1 = 'integer', mu0 = 'integer', diff_exp = 'character')
   r = read_regions(con = r_file, genome = 'hg19', extraCols = extraCols, rename_score = 'coverage')

   a = annotate_regions(
       regions = r,
       annotations = annotations,
       ignore.strand = TRUE)

   sc = summarize_categorical(
       annotated_regions = a,
       by = c('annot.type', 'name'),
       quiet = FALSE)

}
