% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read_annotations}
\alias{read_annotations}
\title{Read custom annotations}
\usage{
read_annotations(con, name, genome = NA, format, extraCols = character(), ...)
}
\arguments{
\item{con}{A path, URL, connection or BEDFile object. See \code{rtracklayer::import.bed()} documentation.}

\item{name}{A string for the name of the annotations to be used in the name of the object, [genome]_custom_[name]}

\item{genome}{From \code{rtracklayer::import()}: The identifier of a genome, or NA if unknown. Typically, this is a UCSC identifier like 'hg19'. An attempt will be made to derive the \code{seqinfo} on the return value using either an installed BSgenome package or UCSC, if network access is available.}

\item{format}{From \code{rtracklayer::import()}: The format of the output. If not missing, should be one of 'bed', 'bed15', 'bedGraph' or 'bedpe'. If missing and 'con' is a filename, the format is derived from the file extension. This argument is unnecessary when 'con' is a derivative of 'RTLFile'.}

\item{extraCols}{From \code{rtracklayer::import.bed()}: A character vector in the same form as 'colClasses' from 'read.table'.  It should indicate the name and class of each extra/special column to read from the BED file. As BED does not encode column names, these are assumed to be the last columns in the file. This enables parsing of the various BEDX+Y formats.}

\item{...}{Parameters to pass onto the format-specific method of \code{rtracklayer::import()}.}
}
\value{
A \code{GRanges} object stored in \code{annotatr_cache}. To view a custom annotation, do \code{annotatr_cache$get(name)}. To add a custom annotation to the set of annotations, include \code{'[genome]_custom_[name]'} in the call to \code{build_annotations()}. See example below.
}
\description{
\code{read_annotations()} is a wrapper for the \code{rtracklayer::import()} function that creates a \code{GRanges} object matching the structure of annotations built with \code{build_annotations()}. The structure is defined by \code{GRanges}, with the \code{mcols()} with names \code{c('id','gene_id','symbol','type')}.
}
\examples{

 # Read in a BED3 file as a custom annotation
 file = system.file('extdata', 'test_annotations_3.bed', package='annotatr')
 read_annotations(con = file, name = 'test', genome = 'hg19')
 build_annotations(genome = 'hg19', annotations = 'hg19_custom_test')

 print(annotatr_cache$get('hg19_custom_test'))

}
