% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{plot_annotation}
\alias{plot_annotation}
\title{Plot the number of regions per annotation}
\usage{
plot_annotation(
  annotated_regions,
  annotated_random,
  annotation_order = NULL,
  plot_title,
  x_label,
  y_label,
  quiet = FALSE
)
}
\arguments{
\item{annotated_regions}{The \code{GRanges} result of \code{annotate_regions()}.}

\item{annotated_random}{The \code{GRanges} result of \code{annotate_regions()} on the randomized regions created from \code{randomize_regions()}.}

\item{annotation_order}{A character vector which doubles as the subset of annotations desired for the plot as well as the ordering. If \code{NULL}, all annotations are displayed.}

\item{plot_title}{A string used for the title of the plot. If missing, no title is displayed.}

\item{x_label}{A string used for the x-axis label. If missing, no x-axis label is displayed.}

\item{y_label}{A string used for the y-axis label. If missing, no y-axis label is displayed.}

\item{quiet}{Print progress messages (FALSE) or not (TRUE).}
}
\value{
A \code{ggplot} object which can be viewed by calling it, saved with \code{ggplot2::ggsave}, or edited.
}
\description{
Given a \code{GRanges} of annotated regions, plot the number of regions with the corresponding genomic annotations used in \code{annotation_order}. If a region is annotated to multiple annotations of the same \code{annot.type}, the region will only be counted once in the corresponding bar plot. For example, if a region were annotated to multiple exons, it would only count once toward the exon bar in the plot, but if it were annotated to an exon and an intron, it would count towards both.
}
\examples{
   ########################################################################
   # An example of ChIP-seq peaks with signalValue used for score

   # Get premade CpG annotations
   data('annotations', package = 'annotatr')

   chip_bed = system.file('extdata', 'Gm12878_Stat3_chr2.bed.gz', package = 'annotatr')
   chip_regions = read_regions(con = chip_bed, genome = 'hg19')

   chip_rnd = randomize_regions(regions = chip_regions)

   chip_annots = annotate_regions(
       regions = chip_regions,
       annotations = annotations,
       ignore.strand = TRUE)

   chip_rnd_annots = annotate_regions(
       regions = chip_rnd,
       annotations = annotations,
       ignore.strand = TRUE)

   annots_order = c(
       'hg19_cpg_islands',
       'hg19_cpg_shores')

   p_annots = plot_annotation(annotated_regions = chip_annots,
       annotation_order = annots_order)
   p_annots_rnd = plot_annotation(annotated_regions = chip_annots,
       annotated_random = chip_rnd_annots, annotation_order = annots_order)

}
