% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annoLinker.R
\name{annoLinker}
\alias{annoLinker}
\title{Annotate Peaks with DNA Interaction Networks Using Graph Clustering}
\usage{
annoLinker(
  peaks,
  annoData,
  interactions,
  bindingType = c("startSite", "body", "endSite"),
  bindingRegion = c(-5000, 5000),
  cluster_method = c("components", "louvain", "walktrap", "infomap"),
  maxgap = 0,
  interactionDistanceRange = c(10000, 1e+07),
  addEvidence = FALSE,
  parallel = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{peaks}{GRanges object containing peak regions}

\item{annoData}{annoGR or GRanges object with gene annotations}

\item{interactions}{GInteractions, or Pairs object with
interaction data (e.g., Hi-C, ChIA-PET)}

\item{bindingType}{Character, one of "startSite", "body", or "endSite"}

\item{bindingRegion}{Numeric vector of length 2 defining promoter window
(e.g., c(-5000, 5000))}

\item{cluster_method}{Character, clustering method: "components" (connected
components), "louvain", "walktrap", or "infomap"}

\item{maxgap}{Integer, bp to extend interaction anchors for
overlap detection (default: 0)}

\item{interactionDistanceRange}{Numeric vector of length 2 defining the
minimal and maximal distance of interactions. This is used to make sure
the annotations are not supper far away.}

\item{addEvidence}{Logical, add evidence to the metadata or not.}

\item{parallel}{Logical, use future_lapply to do parallel computing or not.}

\item{verbose}{Logical, print the message or not}

\item{...}{Parameters for cluster. see \link[igraph]{cluster_louvain},
\link[igraph]{cluster_walktrap}, and \link[igraph]{cluster_infomap}.}
}
\value{
An \link{annoLinkerResult} object
or NULL if no annotations found
}
\description{
Fast annotation of genomic peaks using DNA interaction data by building
interaction networks with igraph. Peaks overlapping any node in a connected
subgraph are annotated with all genes in that subgraph.
}
\examples{
## read the peaks and interactions
library(rtracklayer)
extPath <- system.file("extdata", package = "annoLinker")
peaks <- rtracklayer::import(file.path(extPath, "peaks.bed"))
interactions <- rtracklayer::import(file.path(extPath, "interaction.bedpe"))
library(TxDb.Drerio.UCSC.danRer10.refGene)
annoData <- genes(TxDb.Drerio.UCSC.danRer10.refGene)
anno <- annoLinker(peaks, annoData, interactions, verbose = TRUE)
}
