% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimred_umap.R
\name{dimred_umap}
\alias{dimred_umap}
\title{Dimensionality reduction through PCA}
\usage{
dimred_umap(
  MAE,
  tax_level,
  color,
  shape = NULL,
  cx = 1,
  cy = 2,
  cz = NULL,
  n_neighbors = 15,
  metric = c("euclidean", "manhattan"),
  n_epochs = 200,
  init = c("spectral", "random"),
  min_dist = 0.1,
  datatype = c("logcpm", "relabu", "counts")
)
}
\arguments{
\item{MAE}{A multi-assay experiment object}

\item{tax_level}{The taxon level used for organisms}

\item{color}{A condition to color data points by e.g. "AGE"}

\item{shape}{A condition to shape data points by e.g. "SEX"}

\item{cx}{Component on the x-axis e.g. 1}

\item{cy}{Component on the y-axis e.g. 2}

\item{cz}{Component on the z-axis e.g. 3}

\item{n_neighbors}{Number of nearest neighbors}

\item{metric}{Distance function e.g. c("euclidean", "manhattan")}

\item{n_epochs}{Number of iterations}

\item{init}{Initial embedding using eigenvector e.g c("spectral", "random")}

\item{min_dist}{Determines how close points appear in the final layout}

\item{datatype}{Datatype to use e.g. c("logcpm", "relabu", "counts")}
}
\value{
A list with a plotly object and summary table
}
\description{
Dimensionality reduction through PCA
}
\examples{
data_dir <- system.file("extdata/MAE.rds", package = "animalcules")
toy_data <- readRDS(data_dir)
result <- dimred_umap(toy_data,
  tax_level = "genus",
  color = "AGE",
  shape = "DISEASE",
  cx = 1,
  cy = 2,
  datatype = "logcpm"
)
result$plot

}
