% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimred_pca.R
\name{dimred_pca}
\alias{dimred_pca}
\title{Dimensionality reduction through PCA}
\usage{
dimred_pca(
  MAE,
  tax_level,
  color,
  shape = NULL,
  pcx = 1,
  pcy = 2,
  pcz = NULL,
  datatype = c("logcpm", "relabu", "counts")
)
}
\arguments{
\item{MAE}{A multi-assay experiment object}

\item{tax_level}{The taxon level used for organisms}

\item{color}{A condition to color data points by e.g. "AGE"}

\item{shape}{A condition to shape data points by e.g. "SEX"}

\item{pcx}{Principal component on the x-axis e.g. 1}

\item{pcy}{Principal component on the y-axis e.g. 2}

\item{pcz}{Principal component on the z-axis e.g. 3}

\item{datatype}{Datatype to use e.g. c("logcpm", "relabu", "counts")}
}
\value{
A list with a plotly object and summary table
}
\description{
Dimensionality reduction through PCA
}
\examples{
data_dir <- system.file("extdata/MAE.rds", package = "animalcules")
toy_data <- readRDS(data_dir)
result <- dimred_pca(toy_data,
  tax_level = "genus",
  color = "AGE",
  shape = "DISEASE",
  pcx = 1,
  pcy = 2,
  datatype = "logcpm"
)
result$plot
result$table

}
