% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomAnansi.R
\name{randomAnansi}
\alias{randomAnansi}
\alias{randomWeb}
\alias{randomMultiFactor}
\alias{krebsDemoWeb}
\title{Generate a random AnansiWeb or MultiFactor}
\usage{
randomWeb(
  n_samples = 10,
  n_reps = 1L,
  n_features_x = 8,
  n_features_y = 12,
  sparseness = 0.5,
  tableY = NULL,
  tableX = NULL,
  dictionary = NULL
)

randomMultiFactor(n_types = 6, n_features = 100, sparseness = 0.5)

krebsDemoWeb(n_samples = 100, n_reps = 4L)
}
\arguments{
\item{n_samples, n_reps}{\verb{Numeric scalar} Number of samples and repeated
measures of those samples to be generated. Ignored if \code{tableY} and
\code{tableX} are provided. (defaults: 10 samples without repeats)}

\item{n_features_y, n_features_x}{\verb{Numeric scalar} Number of features to be
generated. Ignored if \code{tableY} and \code{tableX} are provided.}

\item{sparseness}{\verb{Numeric scalar}, proportion: How rare are connections}

\item{tableY, tableX}{A table containing features of interest. Rows should be
samples and columns should be features. Y and X refer to the position of
the features in a formula: Y ~ X.}

\item{dictionary}{A binary adjacency matrix of class \code{Matrix}, or
coercible to \code{Matrix}.}

\item{n_types}{\verb{Numeric scalar}, number of types of features to generate}

\item{n_features}{\verb{Numeric scalar}, number of features per type}
}
\value{
a randomly generated object of the specified class.
}
\description{
Randomly generate a valid \code{AnansiWeb} or \code{MultiFactor} object.
}
\examples{
# Make a random AnansiWeb object
randomWeb()
krebsDemoWeb()
randomMultiFactor()
}
\seealso{
\code{\link[=AnansiWeb]{AnansiWeb()}}, \code{\link[=MultiFactor]{MultiFactor()}}
}
