% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readAlevinQC.R
\name{readAlevinQC}
\alias{readAlevinQC}
\title{Read alevin data required to generate summary report}
\usage{
readAlevinQC(baseDir, customCBList = list())
}
\arguments{
\item{baseDir}{Path to the output directory from the alevin run (should be
the directory containing the \code{alevin} directory).}

\item{customCBList}{Named list with custom set(s) of barcodes to provide
summary statistics/plots for, in addition to the whitelists generated by
alevin.}
}
\value{
A list collecting all necessary information for generating the
  summary report/shiny app.
}
\description{
Read all alevin output files required to generate the summary report or shiny
app.
}
\examples{
alevin <- readAlevinQC(system.file("extdata/alevin_example_v0.14",
                       package = "alevinQC"))

}
\author{
Charlotte Soneson
}
