% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAlevinBarcodeCollapse.R
\name{plotAlevinBarcodeCollapse}
\alias{plotAlevinBarcodeCollapse}
\title{Summary plot of cell barcode collapsing}
\usage{
plotAlevinBarcodeCollapse(
  cbTable,
  firstSelColName = "inFirstWhiteList",
  countCol = "collapsedFreq"
)
}
\arguments{
\item{cbTable}{\code{data.frame} (such as the \code{cbTable} returned by
\code{readAlevinQC} or \code{readAlevinFryQC}) with barcode frequencies
before and after collapsing.}

\item{firstSelColName}{Character scalar indicating the name of the logical
column in \code{cbTable} that corresponds to the original selection of
barcodes for quantification.}

\item{countCol}{Character scalar indicating the name of the column in
\code{cbTable} that corresponds to the collapsed barcode frequencies.}
}
\value{
A ggplot object
}
\description{
Plot the original frequency of each cell barcode in the original whitelist
against the frequency after collapsing similar cell barcodes.
}
\examples{
alevin <- readAlevinQC(system.file("extdata/alevin_example_v0.14",
                                   package = "alevinQC"))
plotAlevinBarcodeCollapse(alevin$cbTable)

}
\author{
Charlotte Soneson
}
