% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadSpatialImage.R
\name{loadSpatialImage}
\alias{loadSpatialImage}
\title{Load a spatial image}
\usage{
loadSpatialImage(img.info, project)
}
\arguments{
\item{img.info}{Named list containing the metadata for this assay.}

\item{project}{Object specifying the project of interest.}
}
\value{
A \linkS4class{SpatialImage} containing the image data (or a reference to it).
}
\description{
Load an image as a \linkS4class{SpatialImage} or subclass thereof.
}
\examples{
example(read10xVisium, echo=FALSE)
img <- imgData(spe)$data[[1]]

tmp <- tempfile()
dir.create(tmp)
meta <- stageObject(img, tmp, "whee")

out <- loadSpatialImage(meta, tmp)

}
\author{
Aaron Lun
}
