% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveImages.R
\name{saveObject,SpatRaster-method}
\alias{saveObject,SpatRaster-method}
\title{Save \code{SpatRaster} to disk for \code{alabaster}}
\usage{
\S4method{saveObject}{SpatRaster}(x, path, ...)
}
\arguments{
\item{x}{A Bioconductor object of the specified class.}

\item{path}{String containing the path to a directory in which to save \code{x}.}

\item{...}{Extra parameters passed to \code{\link{writeRaster}}.}
}
\value{
x is saved into \code{path} and \code{NULL} is invisibly returned.
}
\description{
Intended for \code{SpatRasterImage} which really is \code{SpatRaster} that
also inherits from SPE's \code{SpatialImage}. Besides \code{writeRaster},
this function also writes a metadata file in the \code{alabaster} framework.
If the image is not loaded into memory and the original file is already
spatially registered, e.g. it has a spatial extent, then the original file
is copied to a pre-defined place in the on-disk representation of SFE and
\code{writeRaster} is not called.
}
\examples{
library(SFEData)
fp <- tempfile()
fn <- file.path(fp, "vizgen")
d <- VizgenOutput(dataset = "cellpose", file_path = fn)
suppressWarnings(sfe <- readVizgen(d))
img <- getImg(sfe)
class(img)
fsave <- file.path(fp, "img")
saveObject(img, fsave)
img2 <- readObject(fsave)

}
\seealso{
Other saveObject-SFE-image: 
\code{\link{saveObject,BioFormatsImage-method}},
\code{\link{saveObject,ExtImage-method}}
}
\concept{saveObject-SFE-image}
