% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/virtual-wrapper.R
\docType{class}
\name{virtual-wrapper}
\alias{virtual-wrapper}
\alias{Wrapper-class}
\alias{IndexedWrapper-class}
\alias{CompressedWrapper-class}
\alias{CompressedIndexedWrapper-class}
\alias{path}
\alias{path,Wrapper-method}
\alias{index}
\alias{index,IndexedWrapper-method}
\alias{compression}
\alias{show,Wrapper-method}
\alias{show,CompressedWrapper-method}
\alias{show,IndexedWrapper-method}
\alias{show,CompressedIndexedWrapper-method}
\title{Virtual wrapper classes}
\description{
Defines some base classes for the concrete wrappers for specific file formats.
This provides a standard set of methods that can be applied to all Wrapper instances.
}
\section{Wrapper methods}{

Any instance \code{x} of a base Wrapper class can be used with the \code{path(x)} method,
which returns a string containing the path to the file on the current file system.

The Wrapper class inherits from the \linkS4class{Annotated} class,
so users can also get and set metadata via \code{\link{metadata}(x)}.
}

\section{IndexedWrapper methods}{

The IndexedWrapper class inherits from the Wrapper class and can be used with all its methods.
It additionally implements the \code{index(x)} method, which returns another Wrapper object for the associated index file
(or \code{NULL}, if no index file exists).
}

\section{CompressedWrapper methods}{

The CompressedWrapper class inherits from the Wrapper class and can be used with all its methods.
It additionally implements the \code{compression(x)} method, which returns a string specifying the compression strategy.
}

\section{CompressedIndexedWrapper methods}{

The CompressedIndexedWrapper class inherits from both the IndexedWrapper and CompressedWrapper classes and can be used with all their methods.
}

\author{
Aaron Lun
}
