% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveMetadata.R
\name{saveMetadata}
\alias{saveMetadata}
\alias{.processMetadata}
\alias{.processMcols}
\alias{processMetadata}
\alias{processMcols}
\title{Save R-level metadata to disk}
\usage{
saveMetadata(x, metadata.path, mcols.path, ...)
}
\arguments{
\item{x}{A \link[S4Vectors]{Vector} or \link[S4Vectors]{Annotated} object.}

\item{metadata.path}{String containing the path in which to save the \code{metadata}.
If \code{NULL}, no \code{\link[S4Vectors]{metadata}} is saved.}

\item{mcols.path}{String containing the path in which to save the \code{mcols}.
If \code{NULL}, no \code{\link[S4Vectors]{mcols}} is saved.}

\item{...}{Further arguments to be passed to \code{\link{altSaveObject}}.}
}
\value{
The metadata for \code{x} is saved to \code{metadata.path}, and similarly for the \code{mcols}.
}
\description{
Save \code{\link[S4Vectors]{metadata}} and \code{\link[S4Vectors]{mcols}} for \link[S4Vectors]{Annotated} or \link[S4Vectors]{Vector} objects, respectively, to disk.
These are typically used inside \code{\link{saveObject}} methods for concrete subclasses.
}
\details{
If \code{mcols(x)} has no columns, nothing is saved by \code{saveMcols}.
Similarly, if \code{metadata(x)} is an empty list, nothing is saved by \code{saveMetadata}.
This avoids creating unnecessary files with no meaningful content.

If \code{mcols(x)} has non-\code{NULL} row names, these are removed prior to staging.
These names are usually redundant with the names associated with elements of \code{x} itself.
}
\seealso{
\code{\link{readMetadata}}, which restores metadata to the object.
}
\author{
Aaron Lun
}
