% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveBaseList.R
\name{saveBaseList}
\alias{saveBaseList}
\alias{saveObject,list-method}
\alias{stageObject,list-method}
\alias{stageObject,List-method}
\alias{.saveBaseListFormat}
\alias{saveObject,List-method}
\alias{saveBaseListFormat}
\title{Save a base list to disk}
\usage{
\S4method{saveObject}{list}(
  x,
  path,
  list.format = saveBaseListFormat(),
  list.character.vls = NULL,
  ...
)

\S4method{saveObject}{List}(x, path, list.format = saveBaseListFormat(), ...)

saveBaseListFormat(list.format)
}
\arguments{
\item{x}{An ordinary R list, named or unnamed.
Alternatively, a \link[S4Vectors]{List} to be coerced into a list.}

\item{path}{String containing the path to a directory in which to save \code{x}.}

\item{list.format}{String specifying the format in which to save the list.}

\item{list.character.vls}{Logical scalar indicating whether to save character vectors in the custom variable length string (VLS) array format.
If \code{NULL}, this is determined based on a comparison of the expected storage against a fixed length array.
Only used if \code{list.format="hdf5"}.}

\item{...}{Further arguments, passed to \code{\link{altSaveObject}} for complex child objects.}
}
\value{
For the \code{saveObject} method, \code{x} is saved inside \code{dir}.
\code{NULL} is invisibly returned.

For \code{saveBaseListFormat}; if \code{list.format} is missing, a string containing the current format is returned.
If \code{list.format} is supplied, it is used to define the current format, and the \emph{previous} format is returned.
}
\description{
Save a \link{list} or \link[S4Vectors]{List} to a JSON or HDF5 file, with extra files created for any of the more complex list elements (e.g., DataFrames, arrays). 
This uses the \href{https://github.com/ArtifactDB/uzuki2}{uzuki2} specification to ensure that appropriate types are declared.
}
\section{File formats}{

If \code{list.format="json.gz"} (default), the list is saved to a Gzip-compressed JSON file (the default).
This is an easily parsed format with low storage overhead.

If \code{list.format="hdf5"}, \code{x} is saved into a HDF5 file instead.
This format is most useful for random access and for preserving the precision of numerical data.
}

\section{Storing scalars}{

The \pkg{uzuki2} specification (see \url{https://github.com/ArtifactDB/uzuki2}) allows length-1 vectors to be stored as-is or as a scalar.
If a list element is of length 1, \code{saveBaseList} will store it as a scalar on-disk, effectively \dQuote{unboxing} it for languages with a concept of scalars.
Users can override this behavior by adding the \link{AsIs} class to the affected list element, which will force storage as a length-1 vector.
This reflects the decisions made by \code{\link{readBaseList}} and mimics the behavior of packages like \pkg{jsonlite}.
}

\examples{
library(S4Vectors)
ll <- list(A=1, B=LETTERS, C=DataFrame(X=1:5))

tmp <- tempfile()
saveObject(ll, tmp)
list.files(tmp, recursive=TRUE)

}
\seealso{
\url{https://github.com/ArtifactDB/uzuki2} for the specification.

\code{\link{readBaseList}}, to read the list back into the R session.
}
\author{
Aaron Lun
}
