% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wilcoxon.R
\name{wilcoxExt}
\alias{wilcoxExt}
\title{Extension on Pairwise Mann Whitney Wilcoxon Test for partitioning}
\usage{
wilcoxExt(
  sce,
  genecluster,
  threshold,
  adj.matrix,
  p.adjust.method = "none",
  ncores = NULL,
  ...
)
}
\arguments{
\item{sce}{A SingleCellExperiment containing assays (\code{"ratio"},
\code{"counts"}) and colData \code{"x"}}

\item{genecluster}{which gene cluster result want to be returned.
Usually identified interesting gene cluster pattern by
\code{\link{summaryAllelicRatio}}}

\item{threshold}{a vector with candidate thresholds for raw p-value
cut-off. Default is 10^seq(from=-2,to=-0.4,by=0.2).
For details please see vignette}

\item{adj.matrix}{an adjacency matrix with 1 indicates cell states
allowed to be grouped together, 0 otherwise.}

\item{p.adjust.method}{method for adjusting p-values
(see \code{\link[stats]{p.adjust}}). Can be abbreviated}

\item{ncores}{A cluster object created by \code{\link[parallel]{makeCluster}}.
Or an integer to indicate number of child-processes
(integer values are ignored on Windows) for parallel evaluations}

\item{...}{additional arguments to pass to \code{\link[stats]{wilcox.test}}.}
}
\value{
A matrix grouping factor partition and
the significant cut-off threshold
are returned in metadata \code{"partition"} and \code{"threshold"}.
Partation also stored in colData\code{"part"}. Note we recommend the returned 
\code{"threshold"} is not at the ends of input \code{"threshold"}.
}
\description{
Extends the Pairwise Mann Whitney Wilcoxon Test by combining
hierarchical clustering for partition.
}
\examples{
library(S4Vectors)
sce <- makeSimulatedData()
sce <- preprocess(sce)
sce <- geneCluster(sce, G = seq_len(4))
sce_sub <- wilcoxExt(sce, genecluster = 1)
metadata(sce_sub)$partition
metadata(sce_sub)$threshold

# Suppose we have 4 cell states, if we don't want cell state 1
# to be grouped together with other cell states
adj.matrix <- 1 - diag(4)
colnames(adj.matrix) <- rownames(adj.matrix) <- levels(sce$x)
adj.matrix[1, c(2, 3, 4)] <- 0
adj.matrix[c(2, 3, 4), 1] <- 0
thrs <- 10^seq(from = -2, to = -0.4, by = 0.1)
sce_sub <- wilcoxExt(sce,
  genecluster = 1, threshold = thrs,
  adj.matrix = adj.matrix
)
metadata(sce_sub)$partition
}
