% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/advCGD.R
\name{advCGD}
\alias{advCGD}
\title{Implementation of the IDG4C algorithm.}
\usage{
advCGD(
  expr,
  clusters,
  target,
  classifier,
  genes = NULL,
  exclNewTargets = NULL,
  newTarget = NULL,
  alpha = 0.1,
  epsilon = 0,
  slot = NULL,
  stopAtSwitch = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{expr}{a matrix, a data.fram or a Seurat object}

\item{clusters}{a character vector of the clusters to which the cells belong}

\item{target}{the name of the cluster to modify}

\item{classifier}{a classifier in the suitable format.
A classifier function should be formated as follow:
classifier = function(expr, clusters, target){
# Making the classification
c("cell type", score)
}
\code{score} should be numeric between 0 and 1, 1 being the highest confidance
into the cell type classification.
The matrix \code{expr} contains RNA expression values, the vector \code{clusters}
consists of the cluster IDs for each cell in \code{expr}, and \code{target} is the
ID of the cluster for which we want to have a classification.
The function returns a vector with the classification result, and a score.}

\item{genes}{the character vector of genes to study}

\item{exclNewTargets}{the character vector of cell types to exclude as new target}

\item{newTarget}{the name of the new cell type cell type target, this will be the
new prediction cell type after the attack}

\item{alpha}{the alpha parameter of the IDG4C algorithm}

\item{epsilon}{the epsilon parameter of the IDG4C algorithm}

\item{slot}{the slot to modify in case of Seurat object}

\item{stopAtSwitch}{logical, set to TRUE to stop the attack when the new target
set to FALSE to continue the attack until all genes are tested}

\item{verbose}{logical, set to TRUE to activate verbose mode}
}
\value{
a list containing the modified expression matrix, the list of modified genes,
the summary of the attack by gene, the summary of the attack,
the new cell types predictions and the original cell types predictions
}
\description{
Implementation of the IDG4C algorithm.
}
\details{
this function is an implementation of the IDG4C algorithm
which permits to generate adversarial attacks on a classifier on a given
cluster. The attack is done by modifying the expression of the genes by
gradient descent after having inferred if by the finite difference method.
Two parameters alpha and epsilon are used to control the step size of the
modifications.
}
\examples{
MyClassifier <- function(expr, clusters, target) {
   typePredictions <- as.data.frame(matrix(nrow=nrow(expr), ncol=length(unique(clusters))))
   colnames(typePredictions) <- unique(clusters)
   typePredictions[unique(clusters)[1]] <- c(1,0,0,0)
   typePredictions[unique(clusters)[2]] <- c(0,1,1,1)
   rownames(typePredictions) <- 1:4

   list(prediction="T cell", odd=1,
                     typePredictions=t(typePredictions),
                     cellTypes=c("B cell","T cell","T cell","T cell"))
}
rna_expression <- data.frame(CD4=c(0,0,0,0), CD8A=c(1,1,1,1),
    CD8B=c(2,2,3,3))
genes <- c("CD4", "CD8A")
clusters_id <- c("B cell","T cell","T cell","T cell")

advCGD(rna_expression, clusters_id, "T cell",
  MyClassifier, genes=genes, verbose=TRUE)


}
