% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamicNoiseFilter.R
\name{dynamicNoiseFilter}
\alias{dynamicNoiseFilter}
\title{Dynamic Noise filtration}
\usage{
dynamicNoiseFilter(spectrum.df = NULL, DNF = 2, minPeaks = 5,
minInt = 100)
}
\arguments{
\item{spectrum.df}{a dataframe or matrix with two columns:
1. Mass/ Mass-to-charge ratio
2. Intensity}

\item{DNF}{dynamic noise filter minimum signal to noise threshold 
(default = 2), calculated as the ratio between the linear model predicted 
intensity value and the actual intensity.}

\item{minPeaks}{minimum number of signal peaks following dynamic 
noise filtration (default = 5).}

\item{minInt}{integer minimum dynamic noise filter}
}
\value{
a list containing 3 objects:
1. Above.noise The dynamic noise filtered matrix/ dataframe 
2. metaData a dataframe with the following column names:
1. Noise.level the noise level determined by the dynamic noise filter 
function.
2. IntCompSpec Total intensity composite spectrum.
3. TotalIntSNR Sparse ion signal to noise ratio 
(mean intensity/ stdev intensity)
4. nPeaks number of peaks in composite spectrum
3. aboveMinPeaks Logical are the number of signals above the minimum level
}
\description{
Dynamic Noise filtration
}
\details{
Dynamic noise filter adapted from the method described in Xu H. 
and Frietas M. 'A Dynamic Noise Level Algorithm for Spectral Screening of 
Peptide MS/MS Spectra' 2010 BMC Bioinformatics. 
The function iteratively calculates linear models starting from 
the median value of the lower half of all intensities in the spectrum.df. 
The linear model is used to predict the next peak intensity and ratio is 
calculated between the predicted and actual intensity value. 
Assuming that all preceeding intensities included in the linear model 
are noise, the signal to noise ratio between the predicted and actual
values 
should exceed the minimum signal to noise ratio (default DNF = 2). 
The function continues until either the DNF value minimum has been exceeded 
and is also below the maxPeaks or maximum number of peaks value. As the 
function must necessarily calculate potentially hundreds of linear models 
the RcppEigen package is used to increase the speed of computation.
}
