% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AbSeqRep.R
\docType{methods}
\name{+,AbSeqRep,AbSeqCRep-method}
\alias{+,AbSeqRep,AbSeqCRep-method}
\title{Combines a \linkS4class{AbSeqRep} object with
a \linkS4class{AbSeqCRep} object together for comparison}
\usage{
\S4method{+}{AbSeqRep,AbSeqCRep}(e1, e2)
}
\arguments{
\item{e1}{AbSeqRep.}

\item{e2}{AbSeqCRep.}
}
\value{
\linkS4class{AbSeqCRep} object. Calling \code{abseqR}'s
functions on this object will always result in a comparison.
}
\description{
Combines a \linkS4class{AbSeqRep} object with
a \linkS4class{AbSeqCRep} object together for comparison
}
\examples{
# Use example data from abseqR as abseqPy's output, substitute this
# with your own abseqPy output directory
abseqPyOutput <- tempdir()
file.copy(system.file("extdata", "ex", package = "abseqR"), abseqPyOutput, recursive=TRUE)
samples <- abseqReport(file.path(abseqPyOutput, "ex"), report = 0)

# The provided example data has PCR1, PCR2, and PCR3 samples contained within
# pcr1 is an instance of AbSeqRep
pcr1 <- samples[["PCR1"]]
# pcr23 is instance of AbSeqCRep
pcr23 <- samples[["PCR2"]] + samples[["PCR3"]]

# pcr123 is an instance of AbSeqCRep
pcr123 <- pcr1 + pcr23

# you can now call the report function on this object
# report(pcr123)           # uncomment this line to execute report
}
\seealso{
\code{\link{abseqReport}} returns a \code{list} of \code{AbSeqRep}s
}
