% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upstreamAnalysis.R
\name{.plotIGVUpstreamLenDist}
\alias{.plotIGVUpstreamLenDist}
\title{Plot IGV family distribution for a given \code{upstreamLengthRange}}
\usage{
.plotIGVUpstreamLenDist(upstreamDirectories, upstreamOut,
  upstreamLengthRange, lengthType, sampleNames, combinedNames, mashedNames,
  .save = TRUE)
}
\arguments{
\item{upstreamDirectories}{list type. List of sample directories}

\item{upstreamOut}{string type. Output directory}

\item{upstreamLengthRange}{The range of upstream sequences to be included in
this plot. This is usually determined by abseqPy and the format should be as
follows: "min_max", e.g.: 1_15 means range(1, 15) inclusive.string type.}

\item{lengthType}{string type. "" (the empty string) denotes everything
and "_short" denotes a short sequence. abseqPy dictates this because it's
used for locating the files.}

\item{sampleNames}{vector type. 1-1 with upstream directories}

\item{combinedNames}{string type. Title friendly "combined" sample names}

\item{mashedNames}{string type. File friendly "mashed-up" sample names}

\item{.save}{logical type. Save Rdata?}
}
\value{
None
}
\description{
Given an upstream length range,
plot the distributions of IGV family without showing their actual lengths. If
their actual lengths matter, refer
to \code{\link{.plotIGVUpstreamLenDistDetailed}}.
}
