% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diversityAnalysis.R
\name{.calculateDInd}
\alias{.calculateDInd}
\title{Calculates the "standard" diversity indices}
\usage{
.calculateDInd(df)
}
\arguments{
\item{df}{clonotype dataframe. Vegan format:
+---------------------------+
| S.1| S.2| S.3 | S.4 | ... |   (each species should have its own column)
+---------------------------+
| v1 |v2  | v3  | ....      |   (each species' count values are placed in the corresponding column)
+---------------------------+}
}
\value{
dataframe with the column headers:
shannon , simpson.con , simpson.inv , simpson.gini , renyi.0 ,
renyi.1 , renyi.2 , renyi.Inf , hill.0 , hill.1 , hill.2 , hill.Inf

renyi.0 => species richness
renyi.1 => shannon entropy
renyi.2 => inv.gini
renyi.Inf => min.entropy

finally:
   hill_a = exp(renyi_a)
}
\description{
Calculates the "standard" diversity indices
}
