% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{complex_heatmap_exposures}
\alias{complex_heatmap_exposures}
\title{Heatmap to cluster the PIDs on their signature 
exposures (ComplexHeatmap)}
\usage{
complex_heatmap_exposures(
  in_exposures_df,
  in_subgroups_df,
  in_signatures_ind_df,
  in_data_type = "norm exposures",
  in_method = "manhattan",
  in_subgroup_column = "subgroup",
  in_subgroup_colour_column = NULL,
  in_palette = colorRamp2(c(0, 0.2, 0.4, 0.6), c("white", "yellow", "orange", "red")),
  in_cutoff = 0,
  in_filename = NULL,
  in_column_anno_borders = FALSE,
  in_row_anno_borders = FALSE
)
}
\arguments{
\item{in_exposures_df}{Numerical data frame encoding the exposures \code{H},
i.e. which signature contributes how much to which PID (patient identifier
or sample).}

\item{in_subgroups_df}{A data frame indicating which PID (patient or sample
identifyier) belongs to which subgroup}

\item{in_signatures_ind_df}{A data frame containing meta information about
the signatures, especially the asserted colour}

\item{in_data_type}{Title in the figure}

\item{in_method}{Method of the clustering to be supplied to
\code{\link{dist}}. Can be either of: \code{euclidean}, \code{maximum},
\code{manhattan}, \code{canberra}, \code{binary} or \code{minkowski}}

\item{in_subgroup_column}{Indicates the name of the column in which the
subgroup information is encoded in \code{in_subgroups_df}}

\item{in_subgroup_colour_column}{Indicates the name of the column in which
the colour information for subgroups is encoded in \code{in_subgroups_df}.
If NULL, a rainbow palette is used instead.}

\item{in_palette}{Palette with colours for the heatmap. Default is
\code{colorRamp2(c(0, 0.2, 0.4, 0.6), c('white','yellow','orange','red'))}}

\item{in_cutoff}{A numeric value less than 1. Signatures from within \code{W}
with an overall exposure less than \code{in_cutoff} will be discarded for
the clustering.}

\item{in_filename}{A path to save the heatmap. If none is specified, the
figure will be plotted to the running environment.}

\item{in_column_anno_borders}{Whether or not to draw separating lines between
the fields in the annotation}

\item{in_row_anno_borders}{Whether or not to draw separating lines between
the fields in the annotation}
}
\value{
The function doesn't return any value.
}
\description{
The PIDs are clustered according to their signature exposures. uses package
\pkg{ComplexHeatmap} by Zuguang Gu. This function calls: \itemize{ \item
\code{\link[ComplexHeatmap]{rowAnnotation}}, \item
\code{\link[ComplexHeatmap]{HeatmapAnnotation}} and \item
\code{\link[ComplexHeatmap]{Heatmap}} }
}
\details{
It might be necessary to install the newest version of the
development branch of the packages \pkg{circlize} and \pkg{ComplexHeatmap} by
Zuguang Gu: \code{devtools::install_github("jokergoo/circlize")} and
\code{devtools::install_github("jokergoo/ComplexHeatmap")}
}
\examples{
 data(lymphoma_cohort_LCD_results)
 complex_heatmap_exposures(
   rel_lymphoma_Nature2013_COSMIC_cutoff_exposures_df,
   COSMIC_subgroups_df,
   chosen_signatures_indices_df,
   in_data_type="norm exposures",
   in_subgroup_colour_column="col",
   in_method="manhattan",
   in_subgroup_column="subgroup")

}
\seealso{
\code{\link[ComplexHeatmap]{Heatmap}}
}
