% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_SMCs.R
\name{compare_SMCs}
\alias{compare_SMCs}
\title{Compare all strata from different stratifications}
\usage{
compare_SMCs(
  in_stratification_lists_list,
  in_signatures_ind_df,
  output_path,
  in_nrect = 5,
  in_attribute = ""
)
}
\arguments{
\item{in_stratification_lists_list}{List of lists with entries from different
(orthogonal) stratification axes or SMCs}

\item{in_signatures_ind_df}{A data frame containing meta information about
the signatures}

\item{output_path}{Path to directory where the results, especially the figure
produced by \code{\link[corrplot]{corrplot}} is going to be stored.}

\item{in_nrect}{Number of clusters in the clustering procedure provided by
\code{\link[corrplot]{corrplot}}}

\item{in_attribute}{Additional string for the file name where the figure
produced by \code{\link[corrplot]{corrplot}} is going to be stored.}
}
\value{
The comparison matrix of cosine similarities.
}
\description{
Compare all strata from different orthogonal stratification axes, i.e.
othogonal SMCs by cosine similarity of signature exposures. First calls
\itemize{ \item \code{make_strata_df}, then \item \code{\link{plot_strata}}
and finally \item \code{\link{make_comparison_matrix}} }
}
\examples{
 NULL

}
\seealso{
\code{\link{plot_strata}}

\code{\link{make_comparison_matrix}}
}
