% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{annotation_heatmap_exposures}
\alias{annotation_heatmap_exposures}
\title{Heatmap to cluster the PIDs on their signature 
exposures (ComplexHeatmap)}
\usage{
annotation_heatmap_exposures(
  in_exposures_df,
  in_annotation_df,
  in_annotation_col,
  in_signatures_ind_df,
  in_data_type = "norm exposures",
  in_method = "manhattan",
  in_palette = colorRamp2(c(0, 0.2, 0.4, 0.6), c("white", "yellow", "orange", "red")),
  in_cutoff = 0,
  in_filename = NULL,
  in_column_anno_borders = FALSE,
  in_row_anno_borders = FALSE,
  in_show_PIDs = TRUE,
  in_annotation_legend_side = "right"
)
}
\arguments{
\item{in_exposures_df}{Numerical data frame encoding the exposures \code{H},
i.e. which signature contributes how much to which PID (patient identifier
or sample).}

\item{in_annotation_df}{A data frame indicating which PID (patient or sample
identifyier) belongs to which subgroup for all layers of annotation}

\item{in_annotation_col}{A list indicating colour attributions for all layers
of annotation}

\item{in_signatures_ind_df}{A data frame containing meta information about
the signatures, especially the asserted colour}

\item{in_data_type}{Title in the figure}

\item{in_method}{Method of the clustering to be supplied to
\code{\link{dist}}. Can be either of: \code{euclidean}, \code{maximum},
\code{manhattan}, \code{canberra}, \code{binary} or \code{minkowski}}

\item{in_palette}{Palette with colours or colour codes for the heatmap.
Default is \code{colorRamp2(c(0, 0.2, 0.4, 0.6),
c('white','yellow','orange','red'))}}

\item{in_cutoff}{A numeric value less than 1. Signatures from within \code{W}
with an overall exposure less than \code{in_cutoff} will be discarded for
the clustering.}

\item{in_filename}{A path to save the heatmap. If none is specified, the
figure will be plotted to the running environment.}

\item{in_column_anno_borders}{Whether or not to draw separating lines between
the fields in the annotation}

\item{in_row_anno_borders}{Whether or not to draw separating lines between
the fields in the annotation}

\item{in_show_PIDs}{Whether or not to show the PIDs on the x-axis}

\item{in_annotation_legend_side}{Where to put the legends of the annotation
df, default is right.}
}
\value{
The function doesn't return any value.
}
\description{
The PIDs are clustered according to their signature exposures. The procedure
is analogous to \code{\link{complex_heatmap_exposures}}, but enabling more
than one annotation row for the PIDs. This function calls: \itemize{ \item
\code{\link[ComplexHeatmap]{rowAnnotation}}, \item
\code{\link[ComplexHeatmap]{HeatmapAnnotation}} and \item
\code{\link[ComplexHeatmap]{Heatmap}} }
}
\details{
One additional parameter, in_show_legend_bool_vector, indicating
which legends to display, is planned but deactivated in this version of the
package. In order to use this features, it will be necessary to install the
newest version of the packages \pkg{circlize} and \pkg{ComplexHeatmap} by
Zuguang Gu: \code{devtools::install_github("jokergoo/circlize")} and
\code{devtools::install_github("jokergoo/ComplexHeatmap")}
}
\examples{
 NULL

}
\seealso{
\code{\link[ComplexHeatmap]{Heatmap}}

\code{\link{complex_heatmap_exposures}}
}
