% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indel_functions.R
\name{plotExchangeSpectra_indel}
\alias{plotExchangeSpectra_indel}
\title{Plot the spectra of nucleotide exchanges of INDELs}
\usage{
plotExchangeSpectra_indel(
  in_catalogue_df,
  in_colour_vector = NULL,
  in_show_indel = FALSE,
  in_show_axis_title = FALSE,
  in_scales = "free_x",
  in_refLine = NULL,
  in_refAlpha = 0.5,
  in_background = NULL
)
}
\arguments{
\item{in_catalogue_df}{Numerical data frame encoding the exchange spectra to
be displayed, either a mutational catalogue \code{V} or a signatures matrix
\code{W}}

\item{in_colour_vector}{Specifies the colours of the INDELs if non-null}

\item{in_show_indel}{Whether or not to show the INDEL names on the x-axis}

\item{in_show_axis_title}{Whether or not to show the name of the y-axis}

\item{in_scales}{Argument passed on to \code{\link[ggplot2]{facet_grid}}}

\item{in_refLine}{If non-null, value on the y-axis at which a horizontal line
is to be drawn}

\item{in_refAlpha}{Transparency of the horizontal line if it is to be drawn}

\item{in_background}{Option to provide a background theme, e.g.
\code{\link[ggplot2]{theme_grey}}}
}
\value{
The generated barplot - a ggplot2 plot
}
\description{
Plots the spectra of nucelotides in their triplet contexts. If several
columns are present in the input data frame, the spectra are ploted for every
column seperatly. The function is only suitable for a INDEL spectra and for
SNV representation the funtion \code{\link[YAPSA]{plotExchangeSpectra}}
should be used.
}
\examples{
data(sigs_pcawg)
plotExchangeSpectra_indel(PCAWG_SP_ID_sigs_df[,c(6,8)])

}
