% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/access_expressionData_Functions.R
\name{getMolecularProfiles}
\alias{getMolecularProfiles}
\title{Get molecular profiles from a XevaSet object}
\usage{
getMolecularProfiles(object, data.type)
}
\arguments{
\item{object}{The \code{XevaSet}.}

\item{data.type}{\code{character}, where one of the molecular data types is needed.}
}
\value{
An \code{ExpressionSet} where sample names are the \code{biobase.id} of the model.
}
\description{
This function serves to get molecular profiles from a \code{XevaSet} object.
}
\examples{
data(brca)
brca.RNA <- getMolecularProfiles(brca, data.type="RNASeq")
}
