% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_model_batch_data.R
\name{getExperiment}
\alias{getExperiment}
\alias{getExperiment,XevaSet-method}
\title{Get PDX experiment data}
\usage{
getExperiment(
  object,
  model.id = NULL,
  batch = NULL,
  patient.id = NULL,
  drug = NULL,
  control.name = NULL,
  treatment.only = FALSE,
  max.time = NULL,
  vol.normal = FALSE,
  log.volume = FALSE,
  return.list = FALSE,
  impute.value = FALSE,
  concurrent.time = FALSE
)

\S4method{getExperiment}{XevaSet}(
  object,
  model.id = NULL,
  batch = NULL,
  patient.id = NULL,
  drug = NULL,
  control.name = NULL,
  treatment.only = FALSE,
  max.time = NULL,
  vol.normal = FALSE,
  log.volume = FALSE,
  return.list = FALSE,
  impute.value = FALSE,
  concurrent.time = FALSE
)
}
\arguments{
\item{object}{The \code{XevaSet} object.}

\item{model.id}{The \code{model.id} for which data is required, multiple IDs are allowed.}

\item{batch}{Batch name from the \code{XevaSet} or experiment design.}

\item{patient.id}{Patient id from the \code{XevaSet}. Default \code{NULL}.}

\item{drug}{Name of the drug.}

\item{control.name}{Name of drug used as control. Default \code{NULL}.}

\item{treatment.only}{Default \code{FALSE}. If \code{TRUE}, give data for non-zero dose periods only (if dose data are available).}

\item{max.time}{Maximum time for data.}

\item{vol.normal}{If TRUE it will normalize the volume. Default \code{FALSE}.}

\item{log.volume}{If TRUE log of the volume will be used. Default \code{FALSE}.}

\item{return.list}{Default \code{FALSE} will return a \code{data.frame}.}

\item{impute.value}{Default \code{FALSE}. If \code{TRUE}, impute the missing values.}

\item{concurrent.time}{Default \code{FALSE}. If \code{TRUE}, cut the batch data such that control and treatment will end at same time point.}
}
\value{
a \code{data.fram} will all the the values stored in experiment slot
}
\description{
For a given \code{model.id}, \code{getExperiment} will
}
\examples{
data(brca)

getExperiment(brca, model.id="X.6047.uned", treatment.only=TRUE)

getExperiment(brca, model.id=c("X.6047.uned", "X.6047.pael"), treatment.only=TRUE)

getExperiment(brca, batch="X-6047.paclitaxel", treatment.only=TRUE)

ed <- list(batch.name="myBatch", treatment=c("X.6047.LJ16","X.6047.LJ16.trab"),
             control=c("X.6047.uned"))

getExperiment(brca, batch=ed)

}
