% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TENxXenium-class.R
\docType{class}
\name{TENxXenium-class}
\alias{TENxXenium-class}
\alias{.TENxXenium}
\alias{TENxXenium}
\alias{import,TENxXenium,ANY,ANY-method}
\title{A class to represent Xenium output data}
\usage{
TENxXenium(
  resources,
  xeniumOut,
  sample_id = "sample01",
  format = c("mtx", "h5"),
  boundaries_format = c("parquet", "csv.gz"),
  spatialCoordsNames = c("x_centroid", "y_centroid"),
  ...
)

\S4method{import}{TENxXenium,ANY,ANY}(con, format, text, ...)
}
\arguments{
\item{resources}{A \link[TENxIO:TENxFileList-class]{TENxFileList} object or a
file path to the tarball containing the matrix / assay data resources.}

\item{xeniumOut}{\code{character(1)} The path to the Xenium output directory.}

\item{sample_id}{\code{character(1)} A single string specifying the sample ID.}

\item{format}{The format of the output. If missing and \code{con} is a
file name, the format is derived from the file extension. This argument is
unnecessary when \code{con} is a derivative of \link[BiocIO:BiocFile-class]{BiocFile}.}

\item{boundaries_format}{\code{character(1)} Either "parquet" or "csv.gz" to
specify the file extension of the boundaries file. Default is "parquet".}

\item{spatialCoordsNames}{\code{character()} A vector of strings specifying the
names of the columns in the spatial data containing the spatial coordinates.}

\item{...}{In the constructor, additional arguments passed to
\link[TENxIO:TENxFileList-class]{TENxFileList}; otherwise, not used.}

\item{con}{The connection from which data is loaded or to which data is
saved. If this is a \code{character} vector, it is assumed to be a file name and
a corresponding file connection is created and then closed after exporting
the object. If it is a \link[BiocIO:BiocFile-class]{BiocFile} derivative, the
data is loaded from or saved to the underlying resource. If missing, the
function will return the output as a character vector, rather than writing
to a connection.}

\item{text}{If \code{con} is missing, this can be a character vector directly
providing the string data to import.}
}
\value{
A \link[SpatialExperiment:SpatialExperiment]{SpatialExperiment}
object
}
\description{
This class is a composed class of
\link[TENxIO:TENxFileList-class]{TENxFileList} which can contain a list of
\link[TENxIO:TENxFile-class]{TENxFile} objects for the cell-feature matrix. It
is meant to handle a single Xenium sample from 10X Genomics.
}
\details{
Note that one can provide a \code{ref} argument to \code{import} method which
will get passed to the internal \code{splitAltExps} operation. This allows one
to set a \code{mainExpName} in the output object.
}
\section{Functions}{
\itemize{
\item \code{import(con = TENxXenium, format = ANY, text = ANY)}: Import Xenium Analyzer data

}}
\section{Slots}{

\describe{
\item{\code{resources}}{A \link[TENxIO:TENxFileList-class]{TENxFileList} or
\link[TENxIO:TENxH5]{TENxH5} object containing the cell feature matrix.}

\item{\code{boundaries}}{Either a
\link[VisiumIO:TENxSpatialParquet-class]{TENxSpatialParquet} or
\link[VisiumIO:TENxSpatialCSV-class]{TENxSpatialCSV} object containing the
spatial boundaries data.}

\item{\code{coordNames}}{\code{character()} A vector specifying the names
of the columns in the spatial data containing the spatial coordinates.}

\item{\code{sampleId}}{\code{character(1)} A scalar specifying the sample identifier.}

\item{\code{colData}}{\code{TENxSpatialParquet} A
\link[VisiumIO:TENxSpatialParquet-class]{TENxSpatialParquet} object containing
the spatial coordinates data.}

\item{\code{metadata}}{\code{XeniumFile} A \link[=XeniumFile-class]{XeniumFile} object
containing the metadata information.}
}}

\examples{
showClass("TENxXenium")

zipfile <- paste0(
    "https://mghp.osn.xsede.org/bir190004-bucket01/BiocXenDemo/",
    "Xenium_Prime_MultiCellSeg_Mouse_Ileum_tiny_outs.zip"
)
destfile <- XeniumIO:::.cache_url_file(zipfile)
outfold <- file.path(
    tempdir(), tools::file_path_sans_ext(basename(zipfile))
)
if (!dir.exists(outfold))
    dir.create(outfold, recursive = TRUE)
unzip(
    zipfile = destfile, exdir = outfold, overwrite = FALSE
)
TENxXenium(xeniumOut = outfold) |>
    import(ref = "Gene Expression")
}
\seealso{
\url{https://www.10xgenomics.com/support/software/xenium-onboard-analysis/latest/analysis/xoa-output-understanding-outputs}
}
