% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coregulstions.R
\name{get_comigrations_by_name}
\alias{get_comigrations_by_name}
\title{get_comigrations_by_name}
\usage{
get_comigrations_by_name(clustering_result, selected_conditions,
  protein_list, cex = 0.7, alpha = 0.3)
}
\arguments{
\item{clustering_result}{A list containing XINA clustering results. See \link[XINA]{xina_clustering}}

\item{selected_conditions}{A vector of condition names used in XINA clustering results.
The number of selected conditions should be at least two.}

\item{protein_list}{A vector containing gene names.}

\item{cex}{Size of cluster number on block axis. Default if 0.7. See \link[alluvial]{alluvial}}

\item{alpha}{Transparency of alluvia colors. Default is 0.3. See \link[alluvial]{alluvial}}
}
\value{
An alluvial plot displaying comigrations and the data frame containing comigrations of the input proteins
}
\description{
'get_comigrations_by_name' finds proteins comigrated with the given proteins
}
\examples{

# load XINA example data
data(xina_example)

# the clustering result table
all_proteins  <- as.character(example_clusters$aligned$`Gene name`)
# get a vector of experimental conditions analyzed in the clustering results
classes <- as.vector(example_clusters$condition)

comigrated_prots_all <- get_comigrations_by_name(example_clusters, classes, all_proteins[1:3])

}
