% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allClasses.R
\name{setMetricsTable}
\alias{setMetricsTable}
\alias{setMetricsTable,ObjXAI-method}
\title{Set the Metrics Table}
\usage{
setMetricsTable(object, value)
}
\arguments{
\item{object}{An ObjXAI object.}

\item{value}{A data frame to set as the metrics table.}
}
\value{
The modified ObjXAI object.
}
\description{
This method sets the metrics table for an ObjXAI object.
}
\examples{

obj <- new("ObjXAI", 
           data = data.frame(), 
           dataSim = data.frame(), 
           metricsTable = data.frame(Metric = c("Accuracy", "Precision"), 
                                       Value = c(0.95, 0.89)), 
           map = list(), 
           models = list(), 
           modelPredictions = list(), 
           args = list())

setMetricsTable(obj, data.frame(Metric = c("Accuracy", "Precision", "Recall"),
                               Value = c(0.95, 0.89, 0.91)))

}
