% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vmat.R
\name{plotVmat.VmatList}
\alias{plotVmat.VmatList}
\title{A function to plot a computed VmatList}
\usage{
\method{plotVmat}{VmatList}(x, nrow = NULL, ncol = NULL, dir = "v", ...)
}
\arguments{
\item{x}{A VmatList (output of plotVmat.list())}

\item{nrow}{Integer, how many rows in facet?}

\item{ncol}{Integer, how many cols in facet?}

\item{dir}{str, direction of facets?}

\item{...}{additional parameters}
}
\value{
A Vmat ggplot
}
\description{
The plotVmat.VmatList() method forwards the Vmat to plotVmat.default().
}
\examples{
data(bam_test)
data(ce11_proms)
list_params <- list(
    'germline' = list(
        bam_test,
        ce11_proms[ce11_proms$which.tissues == 'Germline']
    ),
    'muscle' = list(
        bam_test,
        ce11_proms[ce11_proms$which.tissues == 'Muscle']
    )
)
V <- plotVmat(
    list_params,
    normFun = 'libdepth+nloci', 
    roll = 5
)
}
